/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.data.ValueProvider;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.translation.in.MappedAttribute;
import pl.edu.icm.unity.engine.api.translation.in.MappedGroup;
import pl.edu.icm.unity.engine.api.translation.in.MappedIdentity;
import pl.edu.icm.unity.engine.api.translation.in.MappingResult;
import pl.edu.icm.unity.webui.common.Styles;
import pl.edu.icm.unity.webui.common.safehtml.HtmlLabel;

public class MappingResultComponent
extends CustomComponent {
    private VerticalLayout mainLayout;
    private VerticalLayout mappingResultWrap;
    private VerticalLayout groupsWrap;
    private Label groupsTitleLabel;
    private VerticalLayout attrsWrap;
    private Grid<MappedAttribute> attrsTable;
    private Grid<MappedGroup> groupsTable;
    private Label attrsTitleLabel;
    private VerticalLayout idsWrap;
    private Grid<MappedIdentity> idsTable;
    private Label idsTitleLabel;
    private HorizontalLayout titleWrap;
    private Label noneLabel;
    private HtmlLabel titleLabel;
    private MessageSource msg;

    public MappingResultComponent(MessageSource msg) {
        this.msg = msg;
        this.buildMainLayout();
        this.setCompositionRoot((Component)this.mainLayout);
        this.mappingResultWrap.setStyleName(Styles.smallMargin.toString());
        this.setVisible(false);
        this.initLabels();
        this.initTables();
    }

    private void initLabels() {
        this.titleLabel.setHtmlValue("MappingResultComponent.title", new Object[0]);
        this.idsTitleLabel.setValue(this.msg.getMessage("MappingResultComponent.idsTitle", new Object[0]));
        this.attrsTitleLabel.setValue(this.msg.getMessage("MappingResultComponent.attrsTitle", new Object[0]));
        this.groupsTitleLabel.setValue(this.msg.getMessage("MappingResultComponent.groupsTitle", new Object[0]));
        this.noneLabel.setValue(this.msg.getMessage("MappingResultComponent.none", new Object[0]));
    }

    private void initTables() {
        this.idsTable.addColumn((ValueProvider & Serializable)v -> v.getMode()).setCaption(this.msg.getMessage("MappingResultComponent.mode", new Object[0]));
        this.idsTable.addColumn((ValueProvider & Serializable)v -> v.getIdentity().getTypeId()).setCaption(this.msg.getMessage("MappingResultComponent.idsTable.type", new Object[0]));
        this.idsTable.addColumn((ValueProvider & Serializable)v -> v.getIdentity().getValue()).setCaption(this.msg.getMessage("MappingResultComponent.idsTable.value", new Object[0]));
        this.attrsTable.addColumn((ValueProvider & Serializable)v -> v.getMode()).setCaption(this.msg.getMessage("MappingResultComponent.mode", new Object[0]));
        this.attrsTable.addColumn((ValueProvider & Serializable)v -> v.getAttribute().getName()).setCaption(this.msg.getMessage("MappingResultComponent.attrsTable.name", new Object[0]));
        this.attrsTable.addColumn((ValueProvider & Serializable)v -> v.getAttribute().getValues()).setCaption(this.msg.getMessage("MappingResultComponent.attrsTable.value", new Object[0]));
        this.groupsTable.addColumn((ValueProvider & Serializable)v -> v.getCreateIfMissing()).setCaption(this.msg.getMessage("MappingResultComponent.mode", new Object[0]));
        this.groupsTable.addColumn((ValueProvider & Serializable)v -> v.getGroup()).setCaption(this.msg.getMessage("MappingResultComponent.groupsTable.group", new Object[0]));
    }

    public void displayMappingResult(MappingResult mappingResult, String inputTranslationProfile) {
        this.titleLabel.setHtmlValue("DryRun.MappingResultComponent.title", new Object[]{inputTranslationProfile});
        this.noneLabel.setValue("");
        this.displayMappingResult(mappingResult);
    }

    public void displayMappingResult(MappingResult mappingResult) {
        if (mappingResult == null || mappingResult.getIdentities().isEmpty() && mappingResult.getAttributes().isEmpty() && mappingResult.getGroups().isEmpty()) {
            this.displayItsTables(Collections.emptyList());
            this.displayAttrsTable(Collections.emptyList());
            this.displayGroups(Collections.emptyList());
            this.noneLabel.setVisible(true);
        } else {
            this.displayItsTables(mappingResult.getIdentities());
            this.displayAttrsTable(mappingResult.getAttributes());
            this.displayGroups(mappingResult.getGroups());
            this.noneLabel.setVisible(false);
        }
        this.setVisible(true);
    }

    private void displayItsTables(List<MappedIdentity> identities) {
        this.idsTable.setItems(Collections.emptyList());
        if (identities.isEmpty()) {
            this.idsWrap.setVisible(false);
        } else {
            this.idsWrap.setVisible(true);
            this.idsTable.setItems(identities);
            this.idsTable.setHeightMode(HeightMode.ROW);
            this.idsTable.setHeightByRows((double)identities.size());
        }
    }

    private void displayAttrsTable(List<MappedAttribute> attributes) {
        this.attrsTable.setItems(Collections.emptyList());
        if (attributes.isEmpty()) {
            this.attrsWrap.setVisible(false);
        } else {
            this.attrsWrap.setVisible(true);
            this.attrsTable.setItems(attributes);
            this.attrsTable.setHeightMode(HeightMode.ROW);
            this.attrsTable.setHeightByRows((double)attributes.size());
        }
    }

    private void displayGroups(List<MappedGroup> groups) {
        this.groupsTable.setItems(Collections.emptyList());
        if (groups.isEmpty()) {
            this.groupsWrap.setVisible(false);
        } else {
            this.groupsWrap.setVisible(true);
            this.groupsTable.setItems(groups);
            this.groupsTable.setHeightMode(HeightMode.ROW);
            this.groupsTable.setHeightByRows((double)groups.size());
        }
    }

    private VerticalLayout buildMainLayout() {
        this.mainLayout = new VerticalLayout();
        this.mainLayout.setSizeFull();
        this.mainLayout.setMargin(false);
        this.setSizeFull();
        this.titleWrap = this.buildTitleWrap();
        this.mainLayout.addComponent((Component)this.titleWrap);
        this.mappingResultWrap = this.buildMappingResultWrap();
        this.mainLayout.addComponent((Component)this.mappingResultWrap);
        this.mainLayout.setExpandRatio((Component)this.mappingResultWrap, 1.0f);
        return this.mainLayout;
    }

    private HorizontalLayout buildTitleWrap() {
        this.titleWrap = new HorizontalLayout();
        this.titleWrap.setWidth("-1px");
        this.titleWrap.setHeight("-1px");
        this.titleWrap.setMargin(false);
        this.titleLabel = new HtmlLabel(this.msg);
        this.titleLabel.setWidth("-1px");
        this.titleLabel.setHeight("-1px");
        this.titleWrap.addComponent((Component)this.titleLabel);
        this.noneLabel = new Label();
        this.noneLabel.setWidth("-1px");
        this.noneLabel.setHeight("-1px");
        this.noneLabel.setValue("Label");
        this.titleWrap.addComponent((Component)this.noneLabel);
        return this.titleWrap;
    }

    private VerticalLayout buildMappingResultWrap() {
        this.mappingResultWrap = new VerticalLayout();
        this.mappingResultWrap.setHeight("-1px");
        this.idsWrap = this.buildIdsWrap();
        this.mappingResultWrap.addComponent((Component)this.idsWrap);
        this.attrsWrap = this.buildAttrsWrap();
        this.mappingResultWrap.addComponent((Component)this.attrsWrap);
        this.groupsWrap = this.buildGroupsWrap();
        this.mappingResultWrap.addComponent((Component)this.groupsWrap);
        return this.mappingResultWrap;
    }

    private VerticalLayout buildIdsWrap() {
        this.idsWrap = new VerticalLayout();
        this.idsWrap.setHeight("-1px");
        this.idsWrap.setMargin(false);
        this.idsTitleLabel = new Label();
        this.idsTitleLabel.setWidth("-1px");
        this.idsTitleLabel.setHeight("-1px");
        this.idsTitleLabel.setValue("Label");
        this.idsWrap.addComponent((Component)this.idsTitleLabel);
        this.idsTable = new Grid();
        this.idsTable.setWidth("100.0%");
        this.idsTable.setHeight("-1px");
        this.idsWrap.addComponent(this.idsTable);
        return this.idsWrap;
    }

    private VerticalLayout buildAttrsWrap() {
        this.attrsWrap = new VerticalLayout();
        this.attrsWrap.setHeight("-1px");
        this.attrsWrap.setMargin(false);
        this.attrsTitleLabel = new Label();
        this.attrsTitleLabel.setWidth("-1px");
        this.attrsTitleLabel.setHeight("-1px");
        this.attrsTitleLabel.setValue("Label");
        this.attrsWrap.addComponent((Component)this.attrsTitleLabel);
        this.attrsTable = new Grid();
        this.attrsTable.setWidth("100.0%");
        this.attrsTable.setHeight("-1px");
        this.attrsWrap.addComponent(this.attrsTable);
        return this.attrsWrap;
    }

    private VerticalLayout buildGroupsWrap() {
        this.groupsWrap = new VerticalLayout();
        this.groupsWrap.setHeight("-1px");
        this.groupsWrap.setMargin(false);
        this.groupsTitleLabel = new Label();
        this.groupsTitleLabel.setWidth("-1px");
        this.groupsTitleLabel.setHeight("-1px");
        this.groupsTitleLabel.setValue("Label");
        this.groupsWrap.addComponent((Component)this.groupsTitleLabel);
        this.groupsTable = new Grid();
        this.groupsTable.setWidth("100.0%");
        this.groupsTable.setHeight("-1px");
        this.groupsWrap.addComponent(this.groupsTable);
        return this.groupsWrap;
    }
}

