/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.data.Binder;
import com.vaadin.event.LayoutEvents;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.Sizeable;
import com.vaadin.server.UserError;
import com.vaadin.shared.ui.dnd.EffectAllowed;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.dnd.DragSourceExtension;
import io.imunity.webconsole.tprofile.ActionEditor;
import io.imunity.webconsole.tprofile.ActionParameterComponentProvider;
import io.imunity.webconsole.tprofile.MappingResultComponent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.bulkops.EntityMVELContextKey;
import pl.edu.icm.unity.engine.api.mvel.MVELExpressionContext;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.translation.TranslationCondition;
import pl.edu.icm.unity.engine.api.translation.form.RegistrationMVELContextKey;
import pl.edu.icm.unity.engine.api.translation.in.InputTranslationAction;
import pl.edu.icm.unity.engine.api.translation.in.InputTranslationContextFactory;
import pl.edu.icm.unity.engine.api.translation.in.InputTranslationMVELContextKey;
import pl.edu.icm.unity.engine.api.translation.in.MappingResult;
import pl.edu.icm.unity.engine.api.translation.out.OutputTranslationMVELContextKey;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.translation.ProfileType;
import pl.edu.icm.unity.types.translation.TranslationAction;
import pl.edu.icm.unity.types.translation.TranslationRule;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.HamburgerMenu;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.NotificationPopup;
import pl.edu.icm.unity.webui.common.Styles;
import pl.edu.icm.unity.webui.common.mvel.MVELExpressionField;
import pl.edu.icm.unity.webui.common.safehtml.HtmlTag;

public class RuleComponent
extends CustomComponent {
    private MessageSource msg;
    private TypesRegistryBase<? extends TranslationActionFactory<?>> tc;
    private ActionEditor actionEditor;
    private MVELExpressionField condition;
    private MappingResultComponent mappingResultComponent;
    private Callback callback;
    private MenuBar.MenuItem top;
    private MenuBar.MenuItem bottom;
    private boolean editMode;
    private ActionParameterComponentProvider actionComponentProvider;
    private FormLayout content;
    private Label info;
    private Button showHide;
    private Binder<TranslationRule> binder;
    private Button dragImg;
    private HamburgerMenu<String> menuBar;
    private MenuBar.MenuItem embedProfileMenuItem;
    private final ProfileType profileType;

    public RuleComponent(MessageSource msg, TypesRegistryBase<? extends TranslationActionFactory<?>> tc, TranslationRule toEdit, ActionParameterComponentProvider actionComponentProvider, ProfileType profileType, Callback callback) {
        this.callback = callback;
        this.msg = msg;
        this.tc = tc;
        this.actionComponentProvider = actionComponentProvider;
        this.profileType = profileType;
        this.editMode = toEdit != null;
        this.initUI(toEdit);
    }

    private void initUI(TranslationRule toEdit) {
        VerticalLayout headerWrapper = new VerticalLayout();
        headerWrapper.setMargin(false);
        headerWrapper.setSpacing(false);
        HorizontalLayout header = new HorizontalLayout();
        header.setSizeFull();
        header.setMargin(false);
        this.showHide = new Button(Images.downArrow.getResource());
        this.showHide.addStyleName(Styles.vButtonLink.toString());
        this.showHide.addStyleName(Styles.toolbarButton.toString());
        this.showHide.addStyleName(Styles.vButtonBorderless.toString());
        this.showHide.addClickListener((Button.ClickListener & Serializable)event -> this.showHideContent(!this.content.isVisible()));
        header.addComponent((Component)this.showHide);
        header.setComponentAlignment((Component)this.showHide, Alignment.MIDDLE_LEFT);
        this.info = new Label("");
        this.info.setSizeFull();
        header.addComponent((Component)this.info);
        header.setComponentAlignment((Component)this.info, Alignment.MIDDLE_LEFT);
        header.setExpandRatio((Component)this.info, 1.0f);
        this.dragImg = new Button(Images.resize.getResource());
        this.dragImg.setSizeFull();
        this.dragImg.setWidth(1.0f, Sizeable.Unit.EM);
        this.dragImg.setStyleName(Styles.vButtonLink.toString());
        this.dragImg.addStyleName(Styles.vButtonBorderless.toString());
        this.dragImg.addStyleName(Styles.link.toString());
        this.dragImg.addStyleName(Styles.dragButton.toString());
        DragSourceExtension dragSource = new DragSourceExtension((AbstractComponent)this.dragImg);
        dragSource.setEffectAllowed(EffectAllowed.MOVE);
        dragSource.setDragData((Object)this);
        header.addComponent((Component)this.dragImg);
        header.setComponentAlignment((Component)this.dragImg, Alignment.MIDDLE_RIGHT);
        this.menuBar = new HamburgerMenu();
        this.menuBar.addItem(this.msg.getMessage("TranslationProfileEditor.remove", new Object[0]), Images.remove.getResource(), (MenuBar.Command & Serializable)s -> this.callback.remove(this));
        this.embedProfileMenuItem = this.menuBar.addItem(this.msg.getMessage("TranslationProfileEditor.embedProfile", new Object[0]), Images.embed.getResource(), this::onEmbedProfileAction);
        this.top = this.menuBar.addItem(this.msg.getMessage("TranslationProfileEditor.moveTop", new Object[0]), Images.topArrow.getResource(), (MenuBar.Command & Serializable)s -> this.callback.moveTop(this));
        this.bottom = this.menuBar.addItem(this.msg.getMessage("TranslationProfileEditor.moveBottom", new Object[0]), Images.bottomArrow.getResource(), (MenuBar.Command & Serializable)s -> this.callback.moveBottom(this));
        header.addComponent(this.menuBar);
        header.setComponentAlignment(this.menuBar, Alignment.MIDDLE_RIGHT);
        header.setExpandRatio(this.menuBar, 0.0f);
        header.addLayoutClickListener((LayoutEvents.LayoutClickListener & Serializable)event -> {
            if (!event.isDoubleClick()) {
                return;
            }
            this.showHideContent(!this.content.isVisible());
        });
        headerWrapper.addComponent((Component)header);
        headerWrapper.addComponent((Component)HtmlTag.horizontalLine());
        this.condition = new MVELExpressionField(this.msg, this.msg.getMessage("TranslationProfileEditor.ruleCondition", new Object[0]), this.msg.getMessage("MVELExpressionField.conditionDesc", new Object[0]), MVELExpressionContext.builder().withTitleKey("TranslationProfileEditor.ruleConditionTitle").withEvalToKey("MVELExpressionField.evalToBoolean").withVars(this.getConditionContextVars()).build());
        this.condition.setStyleName(Styles.vTiny.toString());
        this.condition.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.actionEditor = new ActionEditor(this.msg, this.tc, toEdit == null ? null : toEdit.getAction(), this.actionComponentProvider, this::onActionChanged);
        this.mappingResultComponent = new MappingResultComponent(this.msg);
        VerticalLayout main = new VerticalLayout();
        main.setMargin(false);
        main.setSpacing(false);
        this.content = new FormLayout();
        this.content.addComponent((Component)this.condition);
        this.actionEditor.addToLayout((Layout)this.content);
        this.content.addComponents(new Component[]{this.mappingResultComponent});
        this.content.setMargin(false);
        this.content.setSpacing(true);
        this.showHideContent(false);
        main.addComponent((Component)headerWrapper);
        main.addComponent((Component)this.content);
        this.setCompositionRoot((Component)main);
        this.info.setValue(this.actionEditor.getStringRepresentation());
        this.binder = new Binder(TranslationRule.class);
        this.condition.configureBinding(this.binder, "condition", true);
        this.binder.setBean((Object)new TranslationRule(this.editMode ? toEdit.getCondition() : "true", null));
    }

    private Map<String, String> getConditionContextVars() {
        switch (this.profileType) {
            case BULK_ENTITY_OPS: {
                return EntityMVELContextKey.toMap();
            }
            case INPUT: {
                return InputTranslationMVELContextKey.toMap();
            }
            case OUTPUT: {
                return OutputTranslationMVELContextKey.toMap();
            }
            case REGISTRATION: {
                return RegistrationMVELContextKey.toMap();
            }
        }
        return new HashMap<String, String>();
    }

    private void onEmbedProfileAction(MenuBar.MenuItem item) {
        TranslationAction action;
        try {
            action = this.actionEditor.getAction();
        }
        catch (FormValidationException e) {
            NotificationPopup.showFormError((MessageSource)this.msg);
            return;
        }
        String profile = action.getParameters()[0];
        ProfileType profileType = "includeInputProfile".equals(action.getName()) ? ProfileType.INPUT : ProfileType.OUTPUT;
        this.callback.embedProfile(this, profile, profileType);
    }

    private void onActionChanged(String actionStr, Optional<TranslationAction> action) {
        this.info.setValue(actionStr);
        if (action.isPresent()) {
            String actionName = action.get().getName();
            boolean enableEmbed = "includeInputProfile".equals(actionName) || "includeOutputProfile".equals(actionName);
            this.embedProfileMenuItem.setVisible(enableEmbed);
        } else {
            this.embedProfileMenuItem.setVisible(false);
        }
    }

    public void setReadOnlyMode(boolean readOnly) {
        this.condition.setReadOnly(readOnly);
        this.dragImg.setVisible(!readOnly);
        this.actionEditor.setReadOnlyStyle(readOnly);
        this.menuBar.setVisible(!readOnly);
    }

    public TranslationRule getRule() throws FormValidationException {
        if (!this.binder.isValid()) {
            this.binder.validate();
            throw new FormValidationException();
        }
        TranslationRule rule = (TranslationRule)this.binder.getBean();
        rule.setTranslationAction(this.actionEditor.getAction());
        return rule;
    }

    public void setTopVisible(boolean v) {
        this.top.setVisible(v);
    }

    public void setBottomVisible(boolean v) {
        this.bottom.setVisible(v);
    }

    public void setFocus() {
        this.showHideContent(true);
        this.condition.focus();
    }

    public boolean validateRule() {
        boolean ok = true;
        try {
            this.actionEditor.getAction();
        }
        catch (Exception e) {
            ok = false;
        }
        if (!this.binder.isValid()) {
            this.binder.validate();
            ok = false;
        }
        if (!ok) {
            this.showHideContent(true);
        }
        return ok;
    }

    public void test(RemotelyAuthenticatedInput remoteAuthnInput) {
        this.setReadOnlyStyle(true);
        TranslationRule rule = null;
        try {
            rule = this.getRule();
        }
        catch (Exception e) {
            this.actionEditor.indicateExpressionError(e);
            return;
        }
        Map mvelCtx = InputTranslationContextFactory.createMvelContext((RemotelyAuthenticatedInput)remoteAuthnInput);
        TranslationCondition conditionRule = new TranslationCondition(rule.getCondition());
        try {
            boolean result = conditionRule.evaluate((Object)mvelCtx);
            this.setLayoutForEvaludatedCondition(result);
        }
        catch (EngineException e) {
            this.indicateConditionError((Exception)((Object)e));
        }
        InputTranslationAction action = (InputTranslationAction)rule.getAction();
        try {
            MappingResult mappingResult = action.invoke(remoteAuthnInput, (Object)mvelCtx, null);
            this.displayMappingResult(mappingResult);
        }
        catch (EngineException e) {
            this.actionEditor.indicateExpressionError((Exception)((Object)e));
        }
    }

    private void setLayoutForEvaludatedCondition(boolean conditionResult) {
        this.removeRuleComponentEvaluationStyle();
        this.setColorForInputComponents((conditionResult ? Styles.trueConditionBackground : Styles.falseConditionBackground).toString());
    }

    private void displayMappingResult(MappingResult mappingResult) {
        this.mappingResultComponent.displayMappingResult(mappingResult);
        this.mappingResultComponent.setVisible(true);
    }

    private void indicateConditionError(Exception e) {
        this.condition.setStyleName(Styles.errorBackground.toString());
        this.condition.setComponentError((ErrorMessage)new UserError(NotificationPopup.getHumanMessage((Throwable)e)));
    }

    public void clearTestResult() {
        this.removeRuleComponentEvaluationStyle();
        this.hideMappingResultComponent();
        this.setReadOnlyStyle(false);
    }

    private void setColorForInputComponents(String style) {
        this.condition.setStyleName(style);
        this.actionEditor.setStyle(style);
    }

    private void removeRuleComponentEvaluationStyle() {
        this.condition.removeStyleName(Styles.trueConditionBackground.toString());
        this.condition.removeStyleName(Styles.errorBackground.toString());
        this.condition.removeStyleName(Styles.falseConditionBackground.toString());
        this.condition.setComponentError(null);
        this.actionEditor.removeComponentEvaluationStyle();
    }

    private void hideMappingResultComponent() {
        this.mappingResultComponent.setVisible(false);
    }

    private void setReadOnlyStyle(boolean readOnly) {
        this.condition.setReadOnly(readOnly);
        this.actionEditor.setReadOnlyStyle(readOnly);
    }

    private void showHideContent(boolean show) {
        this.showHide.setIcon(show ? Images.upArrow.getResource() : Images.downArrow.getResource());
        this.content.setVisible(show);
    }

    public void refresh() {
        this.actionEditor.refresh();
    }

    public static interface Callback {
        public boolean remove(RuleComponent var1);

        public boolean moveTop(RuleComponent var1);

        public boolean moveBottom(RuleComponent var1);

        public boolean embedProfile(RuleComponent var1, String var2, ProfileType var3);
    }
}

