/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.ui.Component;
import org.apache.logging.log4j.Logger;
import pl.edu.icm.unity.Constants;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.base.utils.Log;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.types.I18nString;
import pl.edu.icm.unity.types.translation.ActionParameterDefinition;
import pl.edu.icm.unity.types.translation.TranslationAction;
import pl.edu.icm.unity.webui.common.LayoutEmbeddable;
import pl.edu.icm.unity.webui.common.safehtml.HtmlLabel;

public class TranslationActionPresenter
extends LayoutEmbeddable {
    private static final Logger log = Log.getLogger((String)"unity.server.web", TranslationActionPresenter.class);
    private MessageSource msg;
    private TypesRegistryBase<? extends TranslationActionFactory<?>> registry;

    public TranslationActionPresenter(MessageSource msg, TypesRegistryBase<? extends TranslationActionFactory<?>> registry, TranslationAction action) {
        this.msg = msg;
        this.registry = registry;
        this.setInput(action);
    }

    private void setInput(TranslationAction action) {
        String actionName = action.getName();
        ActionParameterDefinition[] pd = null;
        try {
            TranslationActionFactory f = (TranslationActionFactory)this.registry.getByName(actionName);
            pd = f.getActionType().getParameters();
        }
        catch (IllegalArgumentException e) {
            throw new InternalException("The action " + actionName + " is unsupported", (Throwable)e);
        }
        this.addField(this.msg.getMessage("TranslationActionPresenter.action", new Object[0]), "TranslationActionPresenter.codeValue", actionName);
        String[] par = action.getParameters();
        for (int j = 0; j < pd.length && j < par.length; ++j) {
            if (j == 0) {
                this.addField(this.msg.getMessage("TranslationActionPresenter.actionParameters", new Object[0]), "TranslationActionPresenter.actionParameter", pd[j].getName(), this.getParamValue(pd[j], par[j]));
                continue;
            }
            this.addField("", "TranslationActionPresenter.actionParameter", pd[j].getName(), this.getParamValue(pd[j], par[j]));
        }
    }

    protected void addField(String name, String msgKey, Object ... unsafeArgs) {
        HtmlLabel val = new HtmlLabel(this.msg);
        val.setCaption(name);
        val.setHtmlValue(msgKey, unsafeArgs);
        this.addComponent((Component)val);
    }

    private Object getParamValue(ActionParameterDefinition desc, String value) {
        if (value == null) {
            return "";
        }
        try {
            value = ((I18nString)Constants.MAPPER.readValue(value, I18nString.class)).getDefaultLocaleValue(this.msg);
        }
        catch (Exception e) {
            log.error("Can not parse i18n string", (Throwable)e);
        }
        return value.replace("\n", " | ");
    }
}

