/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webconsole.tprofile.TranslationProfileEditor;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.types.translation.TranslationProfile;
import pl.edu.icm.unity.webui.common.AbstractDialog;

public class TranslationProfileEditDialog
extends AbstractDialog {
    private TranslationProfileEditor editor;
    private Callback callback;

    public TranslationProfileEditDialog(MessageSource msg, String caption, Callback callback, TranslationProfileEditor editor) {
        super(msg, caption);
        this.editor = editor;
        this.callback = callback;
        this.setSizeMode(AbstractDialog.SizeMode.LARGE);
    }

    protected Component getContents() throws Exception {
        VerticalLayout vl = new VerticalLayout();
        vl.setMargin(false);
        vl.setSpacing(false);
        vl.addComponent((Component)this.editor);
        vl.setComponentAlignment((Component)this.editor, Alignment.TOP_LEFT);
        vl.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        return vl;
    }

    protected void onConfirm() {
        TranslationProfile profile;
        try {
            profile = this.editor.getProfile();
        }
        catch (Exception e) {
            return;
        }
        if (this.callback.handleProfile(profile)) {
            this.close();
        }
    }

    public void show() {
        super.show();
        this.unbindEnterShortcut();
    }

    public static interface Callback {
        public boolean handleProfile(TranslationProfile var1);
    }
}

