/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.data.Binder;
import com.vaadin.data.HasValue;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.dnd.DropEffect;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.dnd.DropTargetExtension;
import com.vaadin.ui.dnd.event.DropListener;
import io.imunity.webconsole.tprofile.ActionParameterComponentProvider;
import io.imunity.webconsole.tprofile.RuleComponent;
import io.imunity.webconsole.tprofile.StartStopButton;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.authn.remote.RemotelyAuthenticatedInput;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.types.translation.ProfileType;
import pl.edu.icm.unity.types.translation.TranslationProfile;
import pl.edu.icm.unity.types.translation.TranslationRule;
import pl.edu.icm.unity.webui.common.CompactFormLayout;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.NotificationPopup;
import pl.edu.icm.unity.webui.common.Styles;
import pl.edu.icm.unity.webui.common.widgets.DescriptionTextField;

public class TranslationProfileEditor
extends VerticalLayout {
    protected MessageSource msg;
    protected ProfileType type;
    protected TypesRegistryBase<? extends TranslationActionFactory<?>> registry;
    protected TextField name;
    protected DescriptionTextField description;
    private HorizontalLayout rulesHeader;
    protected VerticalLayout rulesLayout;
    protected List<RuleComponent> rules;
    private Button addRule;
    private RemotelyAuthenticatedInput remoteAuthnInput;
    private StartStopButton testProfileButton;
    private ActionParameterComponentProvider actionComponentProvider;
    private Binder<TranslationProfile> binder;
    private boolean readOnlyMode;

    public TranslationProfileEditor(MessageSource msg, TypesRegistryBase<? extends TranslationActionFactory<?>> registry, ProfileType type, ActionParameterComponentProvider actionComponentProvider) {
        this.msg = msg;
        this.registry = registry;
        this.type = type;
        this.actionComponentProvider = actionComponentProvider;
        this.rules = new ArrayList<RuleComponent>();
        this.initUI();
    }

    public void setValue(TranslationProfile toEdit) {
        this.binder.setBean((Object)toEdit);
        this.name.setReadOnly(true);
        this.rules.clear();
        for (TranslationRule trule : toEdit.getRules()) {
            this.addRuleComponentAt(trule, this.rules.size());
        }
        this.refreshRules();
    }

    public TranslationProfile getProfile() throws FormValidationException {
        int nvalidr = 0;
        for (RuleComponent cr : this.rules) {
            if (cr.validateRule()) continue;
            ++nvalidr;
        }
        if (!this.binder.isValid() || nvalidr != 0) {
            this.binder.validate();
            throw new FormValidationException();
        }
        ArrayList<TranslationRule> trules = new ArrayList<TranslationRule>();
        for (RuleComponent cr : this.rules) {
            TranslationRule r = cr.getRule();
            if (r == null) continue;
            trules.add(r);
        }
        return new TranslationProfile(this.name.getValue(), this.description.getValue(), this.type, trules);
    }

    protected void initUI() {
        this.rulesLayout = new VerticalLayout();
        this.rulesLayout.setSpacing(false);
        this.rulesLayout.setMargin(false);
        this.rulesLayout.setHeightUndefined();
        this.rulesLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.rulesLayout.setStyleName(Styles.vDropLayout.toString());
        this.name = new TextField(this.msg.getMessage("TranslationProfileEditor.name", new Object[0]));
        this.description = new DescriptionTextField(this.msg);
        this.rulesHeader = new HorizontalLayout();
        this.rulesHeader.setMargin(false);
        this.addRule = new Button();
        this.addRule.setDescription(this.msg.getMessage("TranslationProfileEditor.newRule", new Object[0]));
        this.addRule.setIcon(Images.add.getResource());
        this.addRule.addStyleName(Styles.vButtonLink.toString());
        this.addRule.addStyleName(Styles.toolbarButton.toString());
        this.addRule.addClickListener((Button.ClickListener & Serializable)event -> this.addRuleComponent(null));
        this.testProfileButton = new StartStopButton();
        this.testProfileButton.setVisible(false);
        this.testProfileButton.setDescription(this.msg.getMessage("TranslationProfileEditor.testProfile", new Object[0]));
        this.testProfileButton.addClickListener(new StartStopButton.StartStopListener(){

            @Override
            public void onStop(StartStopButton.ClickStopEvent event) {
                TranslationProfileEditor.this.clearTestResults();
            }

            @Override
            public void onStart(StartStopButton.ClickStartEvent event) {
                TranslationProfileEditor.this.testRules();
            }
        });
        Label t = new Label(this.msg.getMessage("TranslationProfileEditor.rules", new Object[0]));
        this.rulesHeader.addComponents(new Component[]{t, this.addRule, this.testProfileButton});
        CompactFormLayout main = new CompactFormLayout();
        main.addComponents(new Component[]{this.name, this.description});
        main.setSizeFull();
        VerticalLayout wrapper = new VerticalLayout();
        wrapper.addComponents(new Component[]{main, this.rulesHeader, this.rulesLayout});
        this.binder = new Binder(TranslationProfile.class);
        this.binder.forField((HasValue)this.name).asRequired(this.msg.getMessage("fieldRequired", new Object[0])).bind("name");
        this.binder.bind((HasValue)this.description, "description");
        this.binder.setBean((Object)new TranslationProfile(this.msg.getMessage("TranslationProfileEditor.defaultName", new Object[0]), null, this.type, new ArrayList()));
        this.setSpacing(false);
        this.setMargin(false);
        this.addComponents(new Component[]{wrapper});
        this.refreshRules();
    }

    protected void testRules() {
        for (RuleComponent rule : this.rules) {
            rule.test(this.remoteAuthnInput);
        }
    }

    protected void clearTestResults() {
        for (RuleComponent rule : this.rules) {
            rule.clearTestResult();
        }
    }

    private void addRuleComponent(TranslationRule trule) {
        RuleComponent r = this.addRuleComponentAt(trule, this.rules.size());
        if (trule == null) {
            r.setFocus();
        }
        this.refreshRules();
    }

    private RuleComponent addRuleComponentAt(TranslationRule trule, int index) {
        RuleComponent r = new RuleComponent(this.msg, this.registry, trule, this.actionComponentProvider, this.type, new CallbackImplementation());
        this.rules.add(index, r);
        return r;
    }

    protected void refreshRules() {
        this.rulesLayout.removeAllComponents();
        if (this.rules.size() == 0) {
            return;
        }
        this.rulesLayout.addComponent((Component)this.getDropElement(0));
        for (RuleComponent r : this.rules) {
            if (this.rules.size() > 1) {
                r.setTopVisible(true);
                r.setBottomVisible(true);
                continue;
            }
            r.setTopVisible(false);
            r.setBottomVisible(false);
        }
        this.rules.get(0).setTopVisible(false);
        this.rules.get(this.rules.size() - 1).setBottomVisible(false);
        for (RuleComponent r : this.rules) {
            this.rulesLayout.addComponent((Component)r);
            this.rulesLayout.addComponent((Component)this.getDropElement(this.rules.indexOf((Object)r)));
        }
    }

    public void refresh() {
        this.rules.forEach(r -> r.refresh());
    }

    private HorizontalLayout getDropElement(int pos) {
        HorizontalLayout drop = new HorizontalLayout();
        drop.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        drop.setHeight(1.0f, Sizeable.Unit.EM);
        DropTargetExtension dropTarget = new DropTargetExtension((AbstractComponent)drop);
        dropTarget.setDropEffect(DropEffect.MOVE);
        dropTarget.addDropListener((DropListener & Serializable)event -> {
            Optional dragSource = event.getDragSourceComponent();
            if (dragSource.isPresent() && dragSource.get() instanceof Button) {
                event.getDragData().ifPresent(data -> {
                    RuleComponent sourceRule = (RuleComponent)((Object)((Object)((Object)data)));
                    this.rules.remove((Object)sourceRule);
                    this.rules.add(pos, sourceRule);
                    this.refreshRules();
                });
            }
        });
        return drop;
    }

    public void setRemoteAuthnInput(RemotelyAuthenticatedInput remoteAuthnInput) {
        this.remoteAuthnInput = remoteAuthnInput;
        this.testProfileButton.setVisible(true);
    }

    public void setCopyMode() {
        this.name.setReadOnly(false);
        String old = this.name.getValue();
        this.name.setValue(this.msg.getMessage("TranslationProfileEditor.nameCopy", new Object[]{old}));
    }

    public void setReadOnlyMode() {
        this.name.setReadOnly(true);
        this.description.setReadOnly(true);
        this.addRule.setVisible(false);
        for (RuleComponent rule : this.rules) {
            rule.setReadOnlyMode(true);
        }
        this.readOnlyMode = true;
    }

    public boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    public void rulesOnlyMode() {
        this.removeAllComponents();
        this.addComponent((Component)this.rulesHeader);
        this.addComponent((Component)this.rulesLayout);
    }

    public void focusFirst() {
        this.addRule.focus();
    }

    private final class CallbackImplementation
    implements RuleComponent.Callback {
        private CallbackImplementation() {
        }

        @Override
        public boolean remove(RuleComponent rule) {
            TranslationProfileEditor.this.rules.remove((Object)rule);
            TranslationProfileEditor.this.refreshRules();
            return true;
        }

        @Override
        public boolean moveTop(RuleComponent rule) {
            TranslationProfileEditor.this.rules.remove((Object)rule);
            TranslationProfileEditor.this.rules.add(0, rule);
            TranslationProfileEditor.this.refreshRules();
            return true;
        }

        @Override
        public boolean moveBottom(RuleComponent rule) {
            TranslationProfileEditor.this.rules.remove((Object)rule);
            TranslationProfileEditor.this.rules.add(rule);
            TranslationProfileEditor.this.refreshRules();
            return true;
        }

        @Override
        public boolean embedProfile(RuleComponent rule, String profileName, ProfileType profileType) {
            TranslationProfile profile;
            int indexOf = TranslationProfileEditor.this.rules.indexOf((Object)rule);
            try {
                profile = profileType == ProfileType.INPUT ? TranslationProfileEditor.this.actionComponentProvider.getInputProfile(profileName) : TranslationProfileEditor.this.actionComponentProvider.getOutputProfile(profileName);
            }
            catch (EngineException e) {
                NotificationPopup.showError((MessageSource)TranslationProfileEditor.this.msg, (String)TranslationProfileEditor.this.msg.getMessage("TranslationProfilesComponent.errorReadData", new Object[0]), (Exception)((Object)e));
                return false;
            }
            for (TranslationRule trule : profile.getRules()) {
                TranslationProfileEditor.this.addRuleComponentAt(trule, indexOf++);
            }
            TranslationProfileEditor.this.rules.remove((Object)rule);
            TranslationProfileEditor.this.refreshRules();
            return true;
        }
    }
}

