/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.tprofile;

import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webconsole.tprofile.TranslationActionPresenter;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.types.translation.ProfileMode;
import pl.edu.icm.unity.types.translation.TranslationProfile;
import pl.edu.icm.unity.types.translation.TranslationRule;
import pl.edu.icm.unity.webui.common.CompactFormLayout;
import pl.edu.icm.unity.webui.common.safehtml.HtmlLabel;

public class TranslationProfileViewer
extends VerticalLayout {
    private MessageSource msg;
    protected Label name;
    protected Label description;
    protected Label mode;
    private FormLayout rules;
    private FormLayout main;

    public TranslationProfileViewer(MessageSource msg) {
        this.msg = msg;
        this.initUI();
    }

    protected void initUI() {
        this.main = new CompactFormLayout();
        this.name = new Label();
        this.name.setCaption(this.msg.getMessage("TranslationProfileViewer.name", new Object[0]));
        this.description = new Label();
        this.description.setCaption(this.msg.getMessage("TranslationProfileViewer.description", new Object[0]));
        this.mode = new Label();
        this.mode.setCaption(this.msg.getMessage("TranslationProfileViewer.mode", new Object[0]));
        this.mode.setVisible(false);
        this.rules = new CompactFormLayout();
        this.rules.setMargin(false);
        this.rules.setSpacing(false);
        Label rulesLabel = new Label();
        rulesLabel.setCaption(this.msg.getMessage("TranslationProfileViewer.rules", new Object[0]));
        this.main.addComponents(new Component[]{this.name, this.description, this.mode, rulesLabel, this.rules});
        this.addComponent((Component)this.main);
        this.setSizeFull();
    }

    public void setInput(TranslationProfile profile, TypesRegistryBase<? extends TranslationActionFactory<?>> registry) {
        this.setEmpty();
        if (profile == null) {
            this.main.setVisible(false);
            return;
        }
        this.main.setVisible(true);
        this.name.setValue(profile.getName());
        this.description.setValue(profile.getDescription());
        this.mode.setVisible(false);
        if (!profile.getProfileMode().equals((Object)ProfileMode.DEFAULT)) {
            this.mode.setVisible(true);
            this.mode.setValue(profile.getProfileMode().toString().toLowerCase());
        }
        int i = 0;
        for (TranslationRule rule : profile.getRules()) {
            this.addField(this.msg.getMessage("TranslationProfileViewer.ruleCondition", new Object[]{++i}), "TranslationActionPresenter.codeValue", rule.getCondition());
            TranslationActionPresenter action = new TranslationActionPresenter(this.msg, registry, rule.getAction());
            action.addToLayout((Layout)this.rules);
        }
    }

    protected void addField(String name, String msgKey, Object ... unsafeArgs) {
        HtmlLabel val = new HtmlLabel(this.msg);
        val.setCaption(name);
        val.setHtmlValue(msgKey, unsafeArgs);
        this.rules.addComponent((Component)val);
    }

    protected void setEmpty() {
        this.rules.removeAllComponents();
        this.name.setValue("");
        this.description.setValue("");
        this.mode.setValue("");
    }
}

