/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.utils.tprofile;

import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webconsole.tprofile.ActionParameterComponentProvider;
import io.imunity.webconsole.tprofile.TranslationProfileEditor;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.types.translation.ProfileType;
import pl.edu.icm.unity.types.translation.TranslationProfile;
import pl.edu.icm.unity.webui.common.FormValidationException;
import pl.edu.icm.unity.webui.common.NotificationPopup;
import pl.edu.icm.unity.webui.common.StandardButtonsHelper;
import pl.edu.icm.unity.webui.common.webElements.UnitySubView;

public class EditTranslationProfileSubView
extends CustomComponent
implements UnitySubView {
    private MessageSource msg;
    private TranslationProfileEditor editor;
    private Consumer<TranslationProfile> onConfirm;
    private Runnable onCancel;

    public EditTranslationProfileSubView(MessageSource msg, TypesRegistryBase<? extends TranslationActionFactory<?>> registry, ProfileType type, ActionParameterComponentProvider actionComponentProvider, Consumer<TranslationProfile> onConfirm, Runnable onCancel) {
        this.msg = msg;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
        this.editor = new TranslationProfileEditor(msg, registry, type, actionComponentProvider);
        this.editor.setMargin(false);
        this.editor.rulesOnlyMode();
        this.initUI();
    }

    private void initUI() {
        VerticalLayout main = new VerticalLayout();
        main.addComponent((Component)this.editor);
        main.addComponent((Component)StandardButtonsHelper.buildConfirmEditButtonsBar((MessageSource)this.msg, () -> {
            try {
                this.onConfirm.accept(this.editor.getProfile());
            }
            catch (FormValidationException e) {
                NotificationPopup.showError((MessageSource)this.msg, (String)this.msg.getMessage("EditTranslationProfileSubView.inconsistentConfiguration", new Object[0]), (Exception)((Object)e));
            }
        }, (Runnable)this.onCancel));
        this.setCompositionRoot((Component)main);
    }

    public void setInput(TranslationProfile profile) {
        this.editor.setValue(profile);
        this.editor.focusFirst();
    }

    public List<String> getBredcrumbs() {
        return Arrays.asList(this.msg.getMessage("EditTranslationProfileSubView.breadcrumbs", new Object[0]), this.msg.getMessage("edit", new Object[0]));
    }
}

