/*
 * Decompiled with CFR 0.152.
 */
package io.imunity.webconsole.utils.tprofile;

import com.google.common.collect.Lists;
import com.vaadin.data.HasValue;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import io.imunity.webconsole.tprofile.ActionParameterComponentProvider;
import io.imunity.webconsole.tprofile.TranslationRulesPresenter;
import io.imunity.webconsole.utils.tprofile.EditTranslationProfileSubView;
import java.io.Serializable;
import java.util.EventObject;
import java.util.function.Consumer;
import pl.edu.icm.unity.MessageSource;
import pl.edu.icm.unity.engine.api.translation.TranslationActionFactory;
import pl.edu.icm.unity.engine.api.translation.TranslationProfileGenerator;
import pl.edu.icm.unity.engine.api.utils.TypesRegistryBase;
import pl.edu.icm.unity.exceptions.EngineException;
import pl.edu.icm.unity.exceptions.InternalException;
import pl.edu.icm.unity.types.translation.ProfileType;
import pl.edu.icm.unity.types.translation.TranslationProfile;
import pl.edu.icm.unity.webui.common.Images;
import pl.edu.icm.unity.webui.common.Styles;
import pl.edu.icm.unity.webui.common.webElements.SubViewSwitcher;
import pl.edu.icm.unity.webui.common.webElements.UnitySubView;

public class TranslationProfileField
extends CustomField<TranslationProfile> {
    private TranslationRulesPresenter viewer;
    private MessageSource msg;
    private TypesRegistryBase<? extends TranslationActionFactory<?>> registry;
    private ActionParameterComponentProvider actionComponentProvider;
    private ProfileType type;
    private SubViewSwitcher subViewSwitcher;
    private TranslationProfile value;

    TranslationProfileField(MessageSource msg, ProfileType type, TypesRegistryBase<? extends TranslationActionFactory<?>> registry, ActionParameterComponentProvider actionComponentProvider, SubViewSwitcher subViewSwitcher) {
        this.msg = msg;
        this.type = type;
        this.registry = registry;
        this.actionComponentProvider = actionComponentProvider;
        this.subViewSwitcher = subViewSwitcher;
        this.viewer = new TranslationRulesPresenter(msg, registry);
    }

    public TranslationProfile getValue() {
        return this.value;
    }

    protected Component initContent() {
        VerticalLayout viewerWrapper = new VerticalLayout();
        viewerWrapper.setMargin(false);
        viewerWrapper.setSpacing(false);
        HorizontalLayout profileBar = new HorizontalLayout();
        profileBar.setMargin(false);
        Label profile = new Label(this.msg.getMessage("TranslationProfileField.translationProfile", new Object[0]));
        profileBar.addComponent((Component)profile);
        Button editProfile = new Button();
        EditTranslationProfileSubView editProfileSubView = this.getEditTranslationProfileSubViewInstance(p -> {
            this.subViewSwitcher.exitSubViewAndShowUpdateInfo();
            editProfile.focus();
            this.doSetValue((TranslationProfile)p);
            this.fireEvent((EventObject)new HasValue.ValueChangeEvent((Component)this, (Object)this.value, true));
        }, () -> {
            this.subViewSwitcher.exitSubView();
            editProfile.focus();
        });
        editProfile.addClickListener((Button.ClickListener & Serializable)e -> {
            editProfileSubView.setInput(this.value != null ? this.value.clone() : (this.type.equals((Object)ProfileType.INPUT) ? TranslationProfileGenerator.generateEmbeddedEmptyInputProfile() : TranslationProfileGenerator.generateEmbeddedEmptyOutputProfile()));
            this.subViewSwitcher.goToSubView((UnitySubView)editProfileSubView);
        });
        editProfile.setIcon(Images.edit.getResource());
        editProfile.setStyleName(Styles.vButtonBorderless.toString());
        editProfile.setStyleName(Styles.vButtonLink.toString());
        profileBar.addComponent((Component)editProfile);
        viewerWrapper.addComponent((Component)profileBar);
        viewerWrapper.addComponent((Component)this.viewer);
        return viewerWrapper;
    }

    protected void doSetValue(TranslationProfile value) {
        this.value = value;
        this.viewer.setInput(value != null ? value.getRules() : Lists.newArrayList());
    }

    public EditTranslationProfileSubView getEditTranslationProfileSubViewInstance(Consumer<TranslationProfile> onConfirm, Runnable onCancel) {
        try {
            this.actionComponentProvider.init();
        }
        catch (EngineException e) {
            throw new InternalException("Can not init action provider");
        }
        return new EditTranslationProfileSubView(this.msg, this.registry, this.type, this.actionComponentProvider, onConfirm, onCancel);
    }
}

