/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.disruptor;

import io.jstach.rainbowgum.LogConfig;
import io.jstach.rainbowgum.LogProviderRef;
import io.jstach.rainbowgum.LogPublisher;
import io.jstach.rainbowgum.annotation.LogConfigurable;
import io.jstach.rainbowgum.disruptor.DisruptorLogBuilder;
import io.jstach.rainbowgum.disruptor.DisruptorLogPublisher;
import io.jstach.rainbowgum.spi.RainbowGumServiceProvider;

public class DisruptorConfigurator
implements RainbowGumServiceProvider.Configurator {
    public static final String DISRUPTOR_SCHEME = "disruptor";
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public boolean configure(LogConfig config, RainbowGumServiceProvider.Pass pass) {
        static enum DisruptorProvider implements LogPublisher.PublisherProvider
        {
            INSTANT;


            public LogPublisher.PublisherFactory provide(LogProviderRef ref) {
                return (name, config, appenders) -> ((DisruptorLogBuilder)new DisruptorLogBuilder(name).fromProperties(config.properties(), ref)).build().create(name, config, appenders);
            }
        }
        config.publisherRegistry().register("async", (LogPublisher.PublisherProvider)DisruptorProvider.INSTANT);
        config.publisherRegistry().register(DISRUPTOR_SCHEME, (LogPublisher.PublisherProvider)DisruptorProvider.INSTANT);
        return true;
    }

    @LogConfigurable(prefix="logging.publisher.{name}.", name="DisruptorLogBuilder")
    static LogPublisher.PublisherFactory of(@LogConfigurable.KeyParameter String name, @LogConfigurable.DefaultParameter(value="DEFAULT_BUFFER_SIZE") Integer bufferSize) {
        return DisruptorLogPublisher.of(bufferSize);
    }
}

