/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.disruptor;

import io.jstach.rainbowgum.LogBuilder;
import io.jstach.rainbowgum.LogProperties;
import io.jstach.rainbowgum.LogProperty;
import io.jstach.rainbowgum.LogPublisher;
import io.jstach.rainbowgum.disruptor.DisruptorConfigurator;
import java.util.Map;
import java.util.function.BiConsumer;

public final class DisruptorLogBuilder
implements LogBuilder<DisruptorLogBuilder, LogPublisher.PublisherFactory> {
    static final String PROPERTY_PREFIX = "logging.publisher.{name}.";
    static final String PROPERTY_bufferSize = "logging.publisher.{name}.bufferSize";
    private final String propertyPrefix;
    final LogProperty.Property<Integer> property_bufferSize;
    private final String name;
    private Integer bufferSize = 1024;

    public DisruptorLogBuilder(String name) {
        Map<String, String> prefixParameters = Map.of("name", name);
        this.propertyPrefix = LogProperties.interpolateKey((String)PROPERTY_PREFIX, prefixParameters);
        this.name = name;
        this.property_bufferSize = LogProperty.Property.builder().ofInt().build(LogProperties.interpolateKey((String)PROPERTY_bufferSize, prefixParameters));
    }

    public DisruptorLogBuilder bufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public LogPublisher.PublisherFactory build() {
        return DisruptorConfigurator.of(this.name, (Integer)this.property_bufferSize.require((Object)this.bufferSize));
    }

    public DisruptorLogBuilder fromProperties(LogProperties properties) {
        LogProperty.Validator __v = LogProperty.Validator.of(this.getClass());
        LogProperty.Result _bufferSize = this.property_bufferSize.get(properties).or((Object)this.bufferSize);
        __v.add(_bufferSize);
        __v.validate();
        this.bufferSize = (Integer)_bufferSize.value();
        return this;
    }

    public void toProperties(BiConsumer<String, String> consumer) {
        Integer _bufferSize = this.bufferSize;
        if (_bufferSize != null) {
            consumer.accept(this.property_bufferSize.key(), this.property_bufferSize.propertyString((Object)_bufferSize));
        }
    }

    public String propertyPrefix() {
        return this.propertyPrefix;
    }
}

