/*
 * Decompiled with CFR 0.152.
 */
package io.jstach.rainbowgum.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import io.jstach.rainbowgum.LogAppender;
import io.jstach.rainbowgum.LogConfig;
import io.jstach.rainbowgum.LogEvent;
import io.jstach.rainbowgum.LogPublisher;
import io.jstach.rainbowgum.MetaLog;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jdt.annotation.Nullable;

public final class DisruptorLogPublisher
implements LogPublisher.AsyncLogPublisher {
    private final Disruptor<LogEventCell> disruptor;
    private final RingBuffer<LogEventCell> ringBuffer;
    private final Iterable<? extends LogAppender> appenders;

    public static LogPublisher.PublisherFactory of(final int bufferSize) {
        return new LogPublisher.PublisherFactory(){

            public LogPublisher create(String name, LogConfig config, LogAppender.Appenders appenders) {
                return DisruptorLogPublisher.of(appenders.flags(EnumSet.of(LogAppender.AppenderFlag.REUSE_BUFFER)).asList(), (ThreadFactory)DaemonThreadFactory.INSTANCE, bufferSize);
            }
        };
    }

    public static DisruptorLogPublisher of(Collection<? extends LogAppender> appenders, ThreadFactory threadFactory, int bufferSize) {
        Disruptor disruptor = new Disruptor(LogEventCell::new, bufferSize, threadFactory, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        disruptor.setDefaultExceptionHandler((ExceptionHandler)new LogExceptionHandler(() -> ((Disruptor)disruptor).shutdown()));
        boolean found = false;
        for (LogAppender logAppender : appenders) {
            disruptor.handleEventsWith(new EventHandler[]{new LogEventHandler(logAppender)});
            found = true;
        }
        if (!found) {
            throw new IllegalStateException();
        }
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        DisruptorLogPublisher disruptorLogPublisher = new DisruptorLogPublisher((Disruptor<LogEventCell>)disruptor, (RingBuffer<LogEventCell>)ringBuffer, List.copyOf(appenders));
        return disruptorLogPublisher;
    }

    public void start(LogConfig config) {
        this.disruptor.start();
    }

    DisruptorLogPublisher(Disruptor<LogEventCell> disruptor, RingBuffer<LogEventCell> ringBuffer, Iterable<? extends LogAppender> appenders) {
        this.disruptor = disruptor;
        this.ringBuffer = ringBuffer;
        this.appenders = appenders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogEvent event) {
        long sequence = this.ringBuffer.next();
        try {
            LogEventCell cell = (LogEventCell)this.ringBuffer.get(sequence);
            cell.event = event;
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    public void close() {
        this.disruptor.halt();
    }

    public String toString() {
        return super.toString() + "[appenders=" + String.valueOf(this.appenders) + "]";
    }

    private record LogExceptionHandler(Runnable shutdownHook) implements ExceptionHandler<Object>
    {
        public void handleEventException(Throwable ex, long sequence, Object event) {
            if (!(ex instanceof InterruptedException)) {
                MetaLog.error(DisruptorLogPublisher.class, (Throwable)ex);
                throw new RuntimeException(ex);
            }
            this.shutdownHook.run();
        }

        public void handleOnStartException(Throwable ex) {
            MetaLog.error(DisruptorLogPublisher.class, (Throwable)ex);
        }

        public void handleOnShutdownException(Throwable ex) {
            MetaLog.error(DisruptorLogPublisher.class, (Throwable)ex);
        }
    }

    private record LogEventHandler(LogAppender appender) implements EventHandler<LogEventCell>
    {
        public void onEvent(LogEventCell event, long sequence, boolean endOfBatch) throws Exception {
            LogEvent logEvent = event.event;
            if (logEvent == null) {
                return;
            }
            this.appender.append(logEvent);
        }
    }

    private static class LogEventCell {
        @Nullable LogEvent event;

        private LogEventCell() {
        }
    }
}

