/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.support.DefaultTransactionDefinition;
import java.time.Duration;

public interface TransactionDefinition {
    public static final TransactionDefinition DEFAULT = new DefaultTransactionDefinition();
    public static final TransactionDefinition READ_ONLY = new DefaultTransactionDefinition(){
        {
            this.setReadOnly(true);
        }
    };
    public static final Duration TIMEOUT_DEFAULT = Duration.ofMillis(-1L);

    @NonNull
    default public Propagation getPropagationBehavior() {
        return Propagation.REQUIRED;
    }

    @NonNull
    default public Isolation getIsolationLevel() {
        return Isolation.DEFAULT;
    }

    @NonNull
    default public Duration getTimeout() {
        return TIMEOUT_DEFAULT;
    }

    default public boolean isReadOnly() {
        return false;
    }

    @Nullable
    default public String getName() {
        return null;
    }

    @NonNull
    public static TransactionDefinition of(@NonNull Propagation propagationBehaviour) {
        return new DefaultTransactionDefinition(propagationBehaviour);
    }

    public static enum Isolation {
        DEFAULT(-1),
        READ_UNCOMMITTED(1),
        READ_COMMITTED(2),
        REPEATABLE_READ(4),
        SERIALIZABLE(8);

        private final int code;

        private Isolation(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Isolation valueOf(int code) {
            switch (code) {
                case 1: {
                    return READ_UNCOMMITTED;
                }
                case 2: {
                    return READ_COMMITTED;
                }
                case 4: {
                    return REPEATABLE_READ;
                }
                case 8: {
                    return SERIALIZABLE;
                }
            }
            return DEFAULT;
        }
    }

    public static enum Propagation {
        REQUIRED,
        SUPPORTS,
        MANDATORY,
        REQUIRES_NEW,
        NOT_SUPPORTED,
        NEVER,
        NESTED;

    }
}

