/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.async;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncTransactionStatus;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import io.micronaut.transaction.interceptor.KotlinInterceptedMethodAsyncResultSupplier;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@Internal
public final class AsyncUsingSyncTransactionOperations<C>
implements AsyncTransactionOperations<C> {
    private final SynchronousTransactionManager<C> synchronousTransactionManager;
    @Nullable
    private final CoroutineTxHelper coroutineTxHelper;

    public AsyncUsingSyncTransactionOperations(SynchronousTransactionManager<C> synchronousTransactionManager, @Nullable CoroutineTxHelper coroutineTxHelper) {
        this.synchronousTransactionManager = synchronousTransactionManager;
        this.coroutineTxHelper = coroutineTxHelper;
    }

    @Override
    public <T> CompletionStage<T> withTransaction(TransactionDefinition definition, Function<AsyncTransactionStatus<C>, CompletionStage<T>> handler) {
        try (TransactionSynchronizationManager.TransactionSynchronizationStateOp op = TransactionSynchronizationManager.withGuardedState();){
            CompletionStage<Object> result;
            TransactionSynchronizationManager.TransactionSynchronizationState state = op.getOrCreateState();
            if (this.coroutineTxHelper != null && handler instanceof KotlinInterceptedMethodAsyncResultSupplier) {
                Objects.requireNonNull(this.coroutineTxHelper).setupTxState(((KotlinInterceptedMethodAsyncResultSupplier)handler).getKotlinInterceptedMethod(), state);
            }
            TransactionStatus<C> status = this.synchronousTransactionManager.getTransaction(definition);
            try {
                result = handler.apply(new DefaultAsyncTransactionStatus(status));
            }
            catch (Exception e) {
                CompletableFuture r = new CompletableFuture();
                r.completeExceptionally(e);
                result = r;
            }
            CompletableFuture newResult = new CompletableFuture();
            result.whenComplete((o, throwable) -> {
                block9: {
                    try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(state);){
                        if (throwable == null) {
                            this.synchronousTransactionManager.commit(status);
                            newResult.complete(o);
                            break block9;
                        }
                        try {
                            this.synchronousTransactionManager.rollback(status);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        newResult.completeExceptionally((Throwable)throwable);
                    }
                }
            });
            CompletableFuture completableFuture = newResult;
            return completableFuture;
        }
    }

    private static final class DefaultAsyncTransactionStatus<T>
    implements AsyncTransactionStatus<T> {
        private final TransactionStatus<T> status;

        private DefaultAsyncTransactionStatus(TransactionStatus<T> status) {
            this.status = status;
        }

        @Override
        public boolean isNewTransaction() {
            return this.status.isNewTransaction();
        }

        @Override
        public void setRollbackOnly() {
            this.status.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.status.isRollbackOnly();
        }

        @Override
        public boolean isCompleted() {
            return this.status.isCompleted();
        }

        @Override
        public T getConnection() {
            return this.status.getConnection();
        }
    }
}

