/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.sync;

import io.micronaut.core.annotation.Internal;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.exceptions.TransactionException;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import io.micronaut.transaction.support.TransactionSynchronizationManager;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Internal
public final class SynchronousFromReactiveTransactionManager<T>
implements SynchronousTransactionManager<T> {
    private final ReactorReactiveTransactionOperations<T> reactiveTransactionOperations;
    private final Scheduler scheduler;

    public SynchronousFromReactiveTransactionManager(ReactorReactiveTransactionOperations<T> reactiveTransactionOperations, ExecutorService blockingExecutorService) {
        this.reactiveTransactionOperations = reactiveTransactionOperations;
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)blockingExecutorService);
    }

    @Override
    public TransactionStatus<T> getTransaction(TransactionDefinition definition) throws TransactionException {
        throw this.noSupported();
    }

    @Override
    public void commit(TransactionStatus<T> status) throws TransactionException {
        throw this.noSupported();
    }

    @Override
    public void rollback(TransactionStatus<T> status) throws TransactionException {
        throw this.noSupported();
    }

    @Override
    public T getConnection() {
        throw this.noSupported();
    }

    @Override
    public boolean hasConnection() {
        throw this.noSupported();
    }

    @Override
    public <R> R execute(TransactionDefinition definition, TransactionCallback<T, R> callback) {
        try (TransactionSynchronizationManager.TransactionSynchronizationStateOp op = TransactionSynchronizationManager.withGuardedState();){
            TransactionSynchronizationManager.TransactionSynchronizationState state = op.getOrCreateState();
            Context previousContext = (Context)TransactionSynchronizationManager.unbindResourceIfPossible(ContextView.class);
            Mono result = this.reactiveTransactionOperations.withTransactionMono(definition, status -> Mono.deferContextual(contextView -> {
                try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(state);){
                    TransactionSynchronizationManager.bindResource(ContextView.class, contextView);
                    Mono mono = Mono.justOrEmpty(callback.apply(new DefaultTransactionStatus(status)));
                    return mono;
                }
            }).doAfterTerminate(() -> {
                try (TransactionSynchronizationManager.TransactionSynchronizationStateOp ignore = TransactionSynchronizationManager.withState(state);){
                    TransactionSynchronizationManager.unbindResourceIfPossible(ContextView.class);
                }
            }).subscribeOn(this.scheduler));
            if (previousContext != null) {
                result = result.contextWrite((ContextView)previousContext);
            }
            Object object = result.onErrorMap(e -> {
                if (e instanceof UndeclaredThrowableException) {
                    return e.getCause();
                }
                return e;
            }).block();
            return (R)object;
        }
    }

    @Override
    public <R> R executeRead(TransactionCallback<T, R> callback) {
        return this.execute(TransactionDefinition.READ_ONLY, callback);
    }

    @Override
    public <R> R executeWrite(TransactionCallback<T, R> callback) {
        return this.execute(TransactionDefinition.DEFAULT, callback);
    }

    @NotNull
    private IllegalStateException noSupported() {
        return new IllegalStateException("This synchronous transaction manager is implemented using blocking of the reactive transaction manager and only supports 'execute', 'executeRead' and 'executeWrite' methods.");
    }

    private final class DefaultTransactionStatus<K>
    implements TransactionStatus<K> {
        private final ReactiveTransactionStatus<K> transactionStatus;

        private DefaultTransactionStatus(ReactiveTransactionStatus<K> transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        public Object createSavepoint() throws TransactionException {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }

        @Override
        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }

        @Override
        public void releaseSavepoint(Object savepoint) throws TransactionException {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }

        @Override
        public boolean isNewTransaction() {
            return this.transactionStatus.isNewTransaction();
        }

        @Override
        public void setRollbackOnly() {
            this.transactionStatus.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.transactionStatus.isRollbackOnly();
        }

        @Override
        public boolean isCompleted() {
            return this.transactionStatus.isCompleted();
        }

        @Override
        public boolean hasSavepoint() {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }

        @Override
        public void flush() {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }

        @Override
        public Object getTransaction() {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }

        @Override
        public K getConnection() {
            throw SynchronousFromReactiveTransactionManager.this.noSupported();
        }
    }
}

