/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.impl;

import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.exceptions.TransactionSuspensionNotSupportedException;
import io.micronaut.transaction.support.TransactionSynchronization;

public interface InternalTransaction<T>
extends TransactionStatus<T> {
    public boolean isLocalRollbackOnly();

    public boolean isGlobalRollbackOnly();

    default public void suspend() {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    default public void resume() {
        throw new TransactionSuspensionNotSupportedException("Transaction manager [" + this.getClass().getName() + "] does not support transaction suspension");
    }

    public void triggerBeforeCommit();

    public void triggerAfterCommit();

    public void triggerBeforeCompletion();

    public void triggerAfterCompletion(TransactionSynchronization.Status var1);

    public void releaseHeldSavepoint();

    public void cleanupAfterCompletion();
}

