/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.test;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.spring.tx.test.SpringTransactionTestExecutionListener;
import io.micronaut.test.annotation.TransactionMode;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.test.context.TestMethodInterceptor;
import io.micronaut.test.context.TestMethodInvocationContext;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.support.ExceptionUtil;
import io.micronaut.transaction.sync.SynchronousTransactionOperationsFromReactiveTransactionOperations;
import io.micronaut.transaction.test.SpockMethodTransactionDefinitionProvider;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;

@EachBean(value=TransactionOperations.class)
@Requirements(value={@Requires(classes={TestExecutionListener.class}), @Requires(property="micronaut.test.transactional", value="true", defaultValue="true")})
@Replaces(value=SpringTransactionTestExecutionListener.class)
@Internal
public class DefaultTestTransactionExecutionListener
implements TestExecutionListener,
TestMethodInterceptor<Object> {
    @Nullable
    private final SynchronousTransactionManager<Object> synchronousTransactionManager;
    private final TransactionOperations<Object> transactionManager;
    private final TransactionMode transactionMode;
    private TransactionStatus<Object> tx;
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicInteger setupCounter = new AtomicInteger();
    private final boolean rollback;
    private boolean skipSynchronousTransactionManagerExecution;
    @Nullable
    private final SpockMethodTransactionDefinitionProvider spockMethodTransactionDefinitionProvider;

    protected DefaultTestTransactionExecutionListener(TransactionOperations<Object> transactionManager, @Property(name="micronaut.test.rollback", defaultValue="true") boolean rollback, @Property(name="micronaut.test.transaction-mode", defaultValue="SEPARATE_TRANSACTIONS") TransactionMode transactionMode, @Nullable SpockMethodTransactionDefinitionProvider spockMethodTransactionDefinitionProvider) {
        SynchronousTransactionManager<Object> syncTx;
        this.spockMethodTransactionDefinitionProvider = spockMethodTransactionDefinitionProvider;
        this.transactionManager = transactionManager;
        SynchronousTransactionManager<Object> synchronousTransactionManager = this.synchronousTransactionManager = transactionManager instanceof SynchronousTransactionManager ? (syncTx = (SynchronousTransactionManager<Object>)transactionManager) : null;
        if (transactionMode == TransactionMode.SINGLE_TRANSACTION && transactionManager instanceof SynchronousTransactionOperationsFromReactiveTransactionOperations) {
            throw new IllegalStateException("Transaction mode SINGLE_TRANSACTION is not supported when the transaction manager doesn't support detached transaction!");
        }
        this.rollback = rollback;
        this.transactionMode = transactionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object interceptTest(TestMethodInvocationContext<Object> methodInvocationContext) {
        this.skipSynchronousTransactionManagerExecution = true;
        try {
            Object object = this.transactionManager.execute(TransactionDefinition.DEFAULT, status -> {
                try {
                    return super.interceptTest(methodInvocationContext);
                }
                catch (Throwable e) {
                    throw new UncheckedException(e);
                }
            });
            return object;
        }
        catch (UncheckedException e) {
            Object r = ExceptionUtil.sneakyThrow(e.getCause());
            return r;
        }
        finally {
            this.skipSynchronousTransactionManagerExecution = false;
        }
    }

    public void beforeSetupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    public void afterSetupTest(TestContext testContext) {
        if (this.transactionMode.equals((Object)TransactionMode.SINGLE_TRANSACTION)) {
            this.setupCounter.getAndIncrement();
        } else {
            this.afterTestExecution(false);
        }
    }

    public void beforeCleanupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    public void afterCleanupTest(TestContext testContext) {
        this.afterTestExecution(false);
    }

    public void afterTestExecution(TestContext testContext) {
        if (this.transactionMode.equals((Object)TransactionMode.SINGLE_TRANSACTION)) {
            this.counter.addAndGet(-this.setupCounter.getAndSet(0));
        }
        this.afterTestExecution(this.rollback);
    }

    public void beforeTestExecution(TestContext testContext) {
        if (this.counter.getAndIncrement() == 0) {
            TransactionDefinition definition;
            if (this.skipSynchronousTransactionManagerExecution) {
                return;
            }
            if (this.synchronousTransactionManager == null) {
                throw new IllegalStateException("Transaction manager doesn't support detached transaction and the testing framework doesn't support intercepting the test invocation!");
            }
            AnnotatedElement annotatedElement = testContext.getTestMethod();
            if (this.spockMethodTransactionDefinitionProvider != null) {
                definition = this.spockMethodTransactionDefinitionProvider.provide(annotatedElement);
            } else if (annotatedElement instanceof Method) {
                Method method = (Method)annotatedElement;
                String name = method.getDeclaringClass().getSimpleName() + "." + method.getName();
                definition = TransactionDefinition.named(name);
            } else {
                definition = TransactionDefinition.DEFAULT;
            }
            this.tx = this.synchronousTransactionManager.getTransaction(definition);
        }
    }

    private void afterTestExecution(boolean rollback) {
        if (this.counter.decrementAndGet() == 0) {
            if (this.skipSynchronousTransactionManagerExecution) {
                return;
            }
            if (this.synchronousTransactionManager == null) {
                return;
            }
            if (rollback) {
                this.synchronousTransactionManager.rollback(this.tx);
            } else {
                this.synchronousTransactionManager.commit(this.tx);
            }
        }
    }

    private static class UncheckedException
    extends RuntimeException {
        UncheckedException(Throwable e) {
            super(e);
        }
    }
}

