/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionOperationsRegistry;
import io.micronaut.transaction.annotation.Transactional;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.interceptor.TransactionDataSourceTenantResolver;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import io.micronaut.transaction.support.TransactionUtil;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Internal
public final class TransactionalInterceptor
implements MethodInterceptor<Object, Object> {
    private final Map<TenantExecutableMethod, TransactionInvocation> transactionInvocationMap = new ConcurrentHashMap<TenantExecutableMethod, TransactionInvocation>(30);
    @NonNull
    private final TransactionOperationsRegistry transactionOperationsRegistry;
    @Nullable
    private final TransactionDataSourceTenantResolver tenantResolver;
    private final ConversionService conversionService;

    public TransactionalInterceptor(@NonNull TransactionOperationsRegistry transactionOperationsRegistry, @Nullable TransactionDataSourceTenantResolver tenantResolver, ConversionService conversionService) {
        this.transactionOperationsRegistry = transactionOperationsRegistry;
        this.tenantResolver = tenantResolver;
        this.conversionService = conversionService;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition();
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        String tenantDataSourceName = this.tenantResolver != null ? this.tenantResolver.resolveTenantDataSourceName() : null;
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            ExecutableMethod executableMethod = context.getExecutableMethod();
            TransactionInvocation transactionInvocation = this.transactionInvocationMap.computeIfAbsent(new TenantExecutableMethod(tenantDataSourceName, executableMethod), ignore -> {
                String dataSource = tenantDataSourceName == null ? (String)executableMethod.stringValue(Transactional.class).orElse(null) : tenantDataSourceName;
                TransactionDefinition transactionDefinition = this.resolveTransactionDefinition((ExecutableMethod<Object, Object>)executableMethod);
                switch (interceptedMethod.resultType()) {
                    case PUBLISHER: {
                        ReactiveTransactionOperations reactiveTransactionOperations = this.transactionOperationsRegistry.provideReactive(ReactiveTransactionOperations.class, dataSource);
                        return new TransactionInvocation(null, reactiveTransactionOperations, null, transactionDefinition);
                    }
                    case COMPLETION_STAGE: {
                        AsyncTransactionOperations asyncTransactionOperations = this.transactionOperationsRegistry.provideAsync(AsyncTransactionOperations.class, dataSource);
                        return new TransactionInvocation(null, null, asyncTransactionOperations, transactionDefinition);
                    }
                }
                TransactionOperations transactionManager = this.transactionOperationsRegistry.provideSynchronous(TransactionOperations.class, dataSource);
                return new TransactionInvocation(transactionManager, null, null, transactionDefinition);
            });
            TransactionDefinition definition = transactionInvocation.definition;
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    ReactiveTransactionOperations reactiveTransactionOperations = Objects.requireNonNull(transactionInvocation.reactiveTransactionOperations);
                    if (reactiveTransactionOperations instanceof ReactorReactiveTransactionOperations) {
                        ReactorReactiveTransactionOperations reactorTransactionOperations = (ReactorReactiveTransactionOperations)reactiveTransactionOperations;
                        if (context.getReturnType().isSingleResult()) {
                            return interceptedMethod.handleResult(reactorTransactionOperations.withTransactionMono(definition, status -> Mono.from((Publisher)interceptedMethod.interceptResultAsPublisher())));
                        }
                        return interceptedMethod.handleResult(reactorTransactionOperations.withTransactionFlux(definition, status -> Flux.from((Publisher)interceptedMethod.interceptResultAsPublisher())));
                    }
                    return interceptedMethod.handleResult(reactiveTransactionOperations.withTransaction(definition, status -> interceptedMethod.interceptResultAsPublisher()));
                }
                case COMPLETION_STAGE: {
                    AsyncTransactionOperations asyncTransactionOperations = Objects.requireNonNull(transactionInvocation.asyncTransactionOperations);
                    return interceptedMethod.handleResult(asyncTransactionOperations.withTransaction(definition, status -> interceptedMethod.interceptResultAsCompletionStage()));
                }
                case SYNCHRONOUS: {
                    TransactionOperations transactionManager = Objects.requireNonNull(transactionInvocation.transactionManager);
                    return transactionManager.execute(definition, status -> context.proceed());
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    private TransactionDefinition resolveTransactionDefinition(ExecutableMethod<Object, Object> executableMethod) {
        TransactionDefinition definition = TransactionUtil.getTransactionDefinition(executableMethod.getDeclaringType().getSimpleName() + "." + executableMethod.getMethodName(), executableMethod);
        if (definition == TransactionDefinition.DEFAULT) {
            throw new IllegalStateException("No declared @Transactional annotation present");
        }
        return definition;
    }

    private record TenantExecutableMethod(String dataSource, ExecutableMethod method) {
    }

    private record TransactionInvocation<C>(@Nullable TransactionOperations<C> transactionManager, @Nullable ReactiveTransactionOperations<C> reactiveTransactionOperations, @Nullable AsyncTransactionOperations<C> asyncTransactionOperations, TransactionDefinition definition) {
    }
}

