/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;

@Internal
public abstract class AbstractDataSourceTransactionManagerCondition
implements Condition {
    protected abstract String getTransactionManagerName();

    public boolean matches(ConditionContext context) {
        String dataSourceName;
        BeanResolutionContext beanResolutionContext = context.getBeanResolutionContext();
        if (beanResolutionContext == null) {
            dataSourceName = "default";
        } else {
            Qualifier currentQualifier = beanResolutionContext.getCurrentQualifier();
            if (currentQualifier instanceof Named) {
                Named named = (Named)currentQualifier;
                dataSourceName = named.getName();
            } else {
                dataSourceName = "default";
            }
        }
        return context.getProperty("datasources." + dataSourceName + ".transactionManager", String.class).map(name -> name.equals(this.getTransactionManagerName())).orElse(true);
    }
}

