/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.async;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncTransactionStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@Internal
public final class AsyncUsingSyncTransactionOperations<C>
implements AsyncTransactionOperations<C> {
    private final SynchronousTransactionManager<C> synchronousTransactionManager;

    public AsyncUsingSyncTransactionOperations(SynchronousTransactionManager<C> synchronousTransactionManager) {
        this.synchronousTransactionManager = synchronousTransactionManager;
    }

    @Override
    public <T> CompletionStage<T> withTransaction(TransactionDefinition definition, Function<AsyncTransactionStatus<C>, CompletionStage<T>> handler) {
        CompletableFuture newResult = new CompletableFuture();
        PropagatedContext propagatedContext = PropagatedContext.getOrEmpty();
        try (PropagatedContext.Scope ignore = propagatedContext.propagate();){
            CompletionStage<Object> result;
            TransactionStatus<C> status = this.synchronousTransactionManager.getTransaction(definition);
            try {
                result = handler.apply(new DefaultAsyncTransactionStatus<C>(status));
            }
            catch (Throwable e) {
                CompletableFuture r = new CompletableFuture();
                r.completeExceptionally(e);
                result = r;
            }
            result.whenComplete((o, throwable) -> {
                if (throwable == null) {
                    this.synchronousTransactionManager.commit(status);
                    newResult.complete(o);
                } else {
                    try {
                        this.synchronousTransactionManager.rollback(status);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    newResult.completeExceptionally((Throwable)throwable);
                }
            });
        }
        return newResult;
    }

    private record DefaultAsyncTransactionStatus<T>(TransactionStatus<T> status) implements AsyncTransactionStatus<T>
    {
        @Override
        public boolean isNewTransaction() {
            return this.status.isNewTransaction();
        }

        @Override
        public void setRollbackOnly() {
            this.status.setRollbackOnly();
        }

        @Override
        public boolean isRollbackOnly() {
            return this.status.isRollbackOnly();
        }

        @Override
        public boolean isCompleted() {
            return this.status.isCompleted();
        }

        @Override
        public TransactionDefinition getTransactionDefinition() {
            return this.status.getTransactionDefinition();
        }

        @Override
        @NonNull
        public T getConnection() {
            return this.status.getConnection();
        }
    }
}

