/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.SynchronousConnectionManager;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.exceptions.IllegalTransactionStateException;
import io.micronaut.transaction.exceptions.NestedTransactionNotSupportedException;
import io.micronaut.transaction.exceptions.TransactionException;
import io.micronaut.transaction.exceptions.TransactionUsageException;
import io.micronaut.transaction.exceptions.UnexpectedRollbackException;
import io.micronaut.transaction.impl.InternalTransaction;
import io.micronaut.transaction.support.AbstractPropagatedStatusTransactionOperations;
import io.micronaut.transaction.support.TransactionSynchronization;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractTransactionOperations<T extends InternalTransaction<C>, C>
extends AbstractPropagatedStatusTransactionOperations<T, C>
implements TransactionOperations<C>,
SynchronousTransactionManager<C> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ConnectionOperations<C> connectionOperations;
    @Nullable
    protected final SynchronousConnectionManager<C> synchronousConnectionManager;

    public AbstractTransactionOperations(ConnectionOperations<C> connectionOperations, @Nullable SynchronousConnectionManager<C> synchronousConnectionManager) {
        this.connectionOperations = connectionOperations;
        this.synchronousConnectionManager = synchronousConnectionManager;
    }

    protected ConnectionDefinition getConnectionDefinition(TransactionDefinition transactionDefinition) {
        return transactionDefinition.getConnectionDefinition();
    }

    protected abstract T createNoTxTransactionStatus(@NonNull ConnectionStatus<C> var1, @NonNull TransactionDefinition var2);

    protected abstract T createNewTransactionStatus(@NonNull ConnectionStatus<C> var1, @NonNull TransactionDefinition var2);

    protected abstract T createExistingTransactionStatus(@NonNull ConnectionStatus<C> var1, @NonNull TransactionDefinition var2, @NonNull T var3);

    @Override
    public boolean hasConnection() {
        return this.connectionOperations.findConnectionStatus().isPresent();
    }

    @Override
    protected final <R> R doExecute(@NonNull TransactionDefinition definition, @NonNull TransactionCallback<C, R> callback) {
        ConnectionStatus connectionStatus = this.connectionOperations.findConnectionStatus().orElse(null);
        if (connectionStatus == null) {
            return (R)this.connectionOperations.execute(this.txConnectionDefinition(definition), status -> this.doExecute((ConnectionStatus<C>)status, definition, callback));
        }
        return this.doExecute(connectionStatus, definition, callback);
    }

    private <R> R doExecute(ConnectionStatus<C> connectionStatus, TransactionDefinition definition, TransactionCallback<C, R> callback) {
        InternalTransaction existingTransaction = this.findTransactionStatus().orElse(null);
        if (existingTransaction != null) {
            return this.executeWithExistingTransaction(definition, existingTransaction, callback);
        }
        return this.executeNew(connectionStatus, definition, callback);
    }

    protected abstract void doBegin(T var1);

    protected abstract void doCommit(T var1);

    protected abstract void doRollback(T var1);

    protected void doNestedBegin(T tx) {
        throw this.nestedTxNotSupported();
    }

    protected void doNestedCommit(T tx) {
        throw this.nestedTxNotSupported();
    }

    protected void doNestedRollback(T tx) {
        throw this.nestedTxNotSupported();
    }

    protected Optional<Duration> determineTimeout(TransactionDefinition definition) {
        return definition.getTimeout();
    }

    private ConnectionDefinition txConnectionDefinition(TransactionDefinition definition) {
        return this.getConnectionDefinition(definition);
    }

    private IllegalTransactionStateException newMandatoryTx() {
        return new IllegalTransactionStateException("No existing transaction found for transaction marked with propagation 'mandatory'");
    }

    private NestedTransactionNotSupportedException nestedTxNotSupported() {
        return new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
    }

    private <R> R executeNew(ConnectionStatus<C> connectionStatus, TransactionDefinition definition, TransactionCallback<C, R> callback) {
        return switch (definition.getPropagationBehavior()) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionDefinition.Propagation.REQUIRED, TransactionDefinition.Propagation.REQUIRES_NEW, TransactionDefinition.Propagation.NESTED -> this.executeWithNewTransaction(connectionStatus, definition, callback);
            case TransactionDefinition.Propagation.SUPPORTS, TransactionDefinition.Propagation.NEVER, TransactionDefinition.Propagation.NOT_SUPPORTED -> this.executeWithoutTransaction(connectionStatus, callback);
            case TransactionDefinition.Propagation.MANDATORY -> throw this.newMandatoryTx();
        };
    }

    private <R> R executeWithExistingTransaction(TransactionDefinition definition, T existingTransaction, TransactionCallback<C, R> callback) {
        return switch (definition.getPropagationBehavior()) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionDefinition.Propagation.REQUIRED, TransactionDefinition.Propagation.NESTED, TransactionDefinition.Propagation.SUPPORTS, TransactionDefinition.Propagation.MANDATORY -> this.openConnectionAndExecuteTransaction(definition, existingTransaction, callback);
            case TransactionDefinition.Propagation.REQUIRES_NEW -> this.suspend(existingTransaction, () -> this.connectionOperations.execute(this.txConnectionDefinition(definition), status -> this.executeWithNewTransaction((ConnectionStatus<C>)status, definition, callback)));
            case TransactionDefinition.Propagation.NOT_SUPPORTED -> this.suspend(existingTransaction, () -> this.connectionOperations.execute(ConnectionDefinition.REQUIRES_NEW, status -> this.executeWithoutTransaction((ConnectionStatus<C>)status, callback)));
            case TransactionDefinition.Propagation.NEVER -> throw new TransactionUsageException("Existing transaction found for transaction marked with propagation 'never'");
        };
    }

    protected void doSuspend(T transaction) {
    }

    protected void doResume(T transaction) {
    }

    protected <R> R suspend(T transaction, Supplier<R> callback) {
        return callback.get();
    }

    private <R> R openConnectionAndExecuteTransaction(TransactionDefinition definition, T existingTransaction, TransactionCallback<C, R> callback) {
        ConnectionDefinition txConnectionDefinition = this.txConnectionDefinition(definition);
        return (R)this.connectionOperations.execute(txConnectionDefinition, status -> this.executeTransactional(this.createExistingTransactionStatus((ConnectionStatus<C>)status, definition, existingTransaction), callback, definition));
    }

    private <R> R executeWithNewTransaction(@NonNull ConnectionStatus<C> connectionStatus, @NonNull TransactionDefinition definition, @NonNull TransactionCallback<C, R> callback) {
        return this.executeTransactional(this.createNewTransactionStatus(connectionStatus, definition), callback, definition);
    }

    private <R> R executeWithoutTransaction(@NonNull ConnectionStatus<C> connectionStatus, TransactionCallback<C, R> callback) {
        return callback.apply((TransactionStatus<C>)this.createNoTxTransactionStatus(connectionStatus, TransactionDefinition.DEFAULT));
    }

    private <R> R executeTransactional(T transaction, TransactionCallback<C, R> callback, TransactionDefinition definition) {
        R result;
        this.begin(transaction);
        try {
            result = callback.apply((TransactionStatus<C>)transaction);
        }
        catch (Throwable e) {
            if (definition.rollbackOn(e)) {
                this.rollbackInternal(transaction);
            } else {
                this.commitInternal(transaction);
            }
            throw e;
        }
        this.commitInternal(transaction);
        return result;
    }

    private void begin(T transaction) {
        if (transaction.isNewTransaction()) {
            this.doBegin(transaction);
        } else if (transaction.isNestedTransaction()) {
            this.doNestedBegin(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitInternal(T tx) {
        if (tx.isCompleted()) {
            throw new IllegalTransactionStateException("Transaction is already completed - do not call commit or rollback more than once per transaction");
        }
        if (tx.isLocalRollbackOnly()) {
            this.rollbackInternal(tx);
            return;
        }
        if (tx.isGlobalRollbackOnly()) {
            this.rollbackInternal(tx);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Global transaction is marked as rollback-only but transactional code requested commit");
            }
            throw new UnexpectedRollbackException("Transaction rolled back because it has been marked as rollback-only");
        }
        try {
            boolean beforeCompletionInvoked = false;
            try {
                tx.triggerBeforeCommit();
                tx.triggerBeforeCompletion();
                beforeCompletionInvoked = true;
                if (tx.isNewTransaction()) {
                    this.doCommit(tx);
                } else if (tx.isNestedTransaction()) {
                    this.doNestedCommit(tx);
                }
            }
            catch (UnexpectedRollbackException ex) {
                tx.triggerAfterCompletion(TransactionSynchronization.Status.ROLLED_BACK);
                throw ex;
            }
            catch (TransactionException ex) {
                if (this.isRollbackOnCommitFailure()) {
                    this.doRollbackOnCommitException(tx, ex);
                } else {
                    tx.triggerAfterCompletion(TransactionSynchronization.Status.UNKNOWN);
                }
                throw ex;
            }
            catch (Error | RuntimeException ex) {
                if (!beforeCompletionInvoked) {
                    tx.triggerBeforeCompletion();
                }
                this.doRollbackOnCommitException(tx, ex);
                throw ex;
            }
            try {
                tx.triggerAfterCommit();
            }
            finally {
                tx.triggerAfterCompletion(TransactionSynchronization.Status.COMMITTED);
            }
        }
        finally {
            tx.cleanupAfterCompletion();
        }
    }

    private void rollbackInternal(T tx) {
        try {
            try {
                tx.triggerBeforeCompletion();
                if (tx.isNewTransaction()) {
                    this.doRollback(tx);
                } else if (tx.isNestedTransaction()) {
                    this.doNestedRollback(tx);
                } else {
                    tx.setRollbackOnly();
                }
            }
            catch (Error | RuntimeException ex) {
                tx.triggerAfterCompletion(TransactionSynchronization.Status.UNKNOWN);
                throw ex;
            }
            tx.triggerAfterCompletion(TransactionSynchronization.Status.ROLLED_BACK);
        }
        finally {
            tx.cleanupAfterCompletion();
        }
    }

    private boolean isRollbackOnCommitFailure() {
        return true;
    }

    private void doRollbackOnCommitException(@NonNull T tx, @NonNull Throwable ex) throws TransactionException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initiating transaction rollback after commit exception", ex);
            }
            this.doRollback(tx);
        }
        catch (Error | RuntimeException rbex) {
            this.logger.error("Commit exception overridden by rollback exception", ex);
            tx.triggerAfterCompletion(TransactionSynchronization.Status.UNKNOWN);
            throw rbex;
        }
        tx.triggerAfterCompletion(TransactionSynchronization.Status.ROLLED_BACK);
    }

    @Override
    @NonNull
    public TransactionStatus<C> getTransaction(TransactionDefinition definition) throws TransactionException {
        if (this.synchronousConnectionManager == null) {
            throw new TransactionUsageException("Synchronous connection manager not supported!");
        }
        ConnectionStatus connectionStatus = this.connectionOperations.findConnectionStatus().orElse(null);
        Optional existingTransactionStatus = this.findTransactionStatus();
        if (existingTransactionStatus.isPresent()) {
            InternalTransaction existingTransaction = (InternalTransaction)existingTransactionStatus.get();
            return switch (definition.getPropagationBehavior()) {
                default -> throw new IncompatibleClassChangeError();
                case TransactionDefinition.Propagation.REQUIRED, TransactionDefinition.Propagation.NESTED, TransactionDefinition.Propagation.SUPPORTS, TransactionDefinition.Propagation.MANDATORY -> this.reuseTransaction(definition, connectionStatus, existingTransaction);
                case TransactionDefinition.Propagation.REQUIRES_NEW -> this.suspendAndOpenNewTransaction(definition, existingTransaction);
                case TransactionDefinition.Propagation.NOT_SUPPORTED -> this.suspendAndOpenNewConnection(definition, existingTransaction);
                case TransactionDefinition.Propagation.NEVER -> throw new TransactionUsageException("Existing transaction found for transaction marked with propagation 'never'");
            };
        }
        return switch (definition.getPropagationBehavior()) {
            default -> throw new IncompatibleClassChangeError();
            case TransactionDefinition.Propagation.REQUIRED, TransactionDefinition.Propagation.REQUIRES_NEW, TransactionDefinition.Propagation.NESTED -> this.openNewConnectionAndTransaction(definition);
            case TransactionDefinition.Propagation.SUPPORTS, TransactionDefinition.Propagation.NEVER, TransactionDefinition.Propagation.NOT_SUPPORTED -> this.withNoTransactionStatus(connectionStatus, definition);
            case TransactionDefinition.Propagation.MANDATORY -> throw this.newMandatoryTx();
        };
    }

    @NonNull
    private T reuseTransaction(TransactionDefinition definition, ConnectionStatus<C> connectionStatus, T existingTransaction) {
        T transactionStatus = this.createExistingTransactionStatus(connectionStatus, definition, existingTransaction);
        final PropagatedContext.Scope scope = this.extendCurrentPropagatedContext(transactionStatus).propagate();
        transactionStatus.registerInvocationSynchronization(new TransactionSynchronization(){

            @Override
            public void afterCompletion(TransactionSynchronization.Status status) {
                scope.close();
            }
        });
        this.begin(transactionStatus);
        return transactionStatus;
    }

    @NonNull
    private T suspendAndOpenNewTransaction(TransactionDefinition definition, T existingTransaction) {
        this.doSuspend(existingTransaction);
        ConnectionStatus newConnectionStatus = this.synchronousConnectionManager.getConnection(ConnectionDefinition.REQUIRES_NEW);
        T transactionStatus = this.createNewTransactionStatus(newConnectionStatus, definition);
        PropagatedContext.Scope scope = this.extendCurrentPropagatedContext(transactionStatus).propagate();
        transactionStatus.registerInvocationSynchronization(new TransactionSynchronization(){
            final /* synthetic */ InternalTransaction val$existingTransaction;
            final /* synthetic */ PropagatedContext.Scope val$scope;
            final /* synthetic */ ConnectionStatus val$newConnectionStatus;
            {
                this.val$existingTransaction = internalTransaction;
                this.val$scope = scope;
                this.val$newConnectionStatus = connectionStatus;
            }

            @Override
            public void afterCompletion(TransactionSynchronization.Status status) {
                AbstractTransactionOperations.this.doResume(this.val$existingTransaction);
                this.val$scope.close();
                AbstractTransactionOperations.this.synchronousConnectionManager.complete(this.val$newConnectionStatus);
            }
        });
        this.begin(transactionStatus);
        return transactionStatus;
    }

    @NonNull
    private T suspendAndOpenNewConnection(TransactionDefinition definition, T existingTransaction) {
        this.doSuspend(existingTransaction);
        ConnectionStatus newConnectionStatus = this.synchronousConnectionManager.getConnection(ConnectionDefinition.REQUIRES_NEW);
        T transactionStatus = this.createNoTxTransactionStatus(newConnectionStatus, definition);
        PropagatedContext.Scope scope = this.extendCurrentPropagatedContext(transactionStatus).propagate();
        transactionStatus.registerInvocationSynchronization(new TransactionSynchronization(){
            final /* synthetic */ InternalTransaction val$existingTransaction;
            final /* synthetic */ PropagatedContext.Scope val$scope;
            final /* synthetic */ ConnectionStatus val$newConnectionStatus;
            {
                this.val$existingTransaction = internalTransaction;
                this.val$scope = scope;
                this.val$newConnectionStatus = connectionStatus;
            }

            @Override
            public void afterCompletion(TransactionSynchronization.Status status) {
                AbstractTransactionOperations.this.doResume(this.val$existingTransaction);
                this.val$scope.close();
                AbstractTransactionOperations.this.synchronousConnectionManager.complete(this.val$newConnectionStatus);
            }
        });
        this.begin(transactionStatus);
        return transactionStatus;
    }

    @NonNull
    private T openNewConnectionAndTransaction(TransactionDefinition definition) {
        final ConnectionStatus newConnectionStatus = this.synchronousConnectionManager.getConnection(ConnectionDefinition.REQUIRES_NEW);
        T transactionStatus = this.createNewTransactionStatus(newConnectionStatus, definition);
        final PropagatedContext.Scope scope = this.extendCurrentPropagatedContext(transactionStatus).propagate();
        transactionStatus.registerInvocationSynchronization(new TransactionSynchronization(){

            @Override
            public void afterCompletion(TransactionSynchronization.Status status) {
                scope.close();
                AbstractTransactionOperations.this.synchronousConnectionManager.complete(newConnectionStatus);
            }
        });
        this.begin(transactionStatus);
        return transactionStatus;
    }

    @NonNull
    private T withNoTransactionStatus(ConnectionStatus<C> connectionStatus, TransactionDefinition definition) {
        T transactionStatus = this.createNoTxTransactionStatus(connectionStatus, definition);
        final PropagatedContext.Scope scope = this.extendCurrentPropagatedContext(transactionStatus).propagate();
        transactionStatus.registerInvocationSynchronization(new TransactionSynchronization(){

            @Override
            public void afterCompletion(TransactionSynchronization.Status status) {
                scope.close();
            }
        });
        this.begin(transactionStatus);
        return transactionStatus;
    }

    @Override
    public void commit(TransactionStatus<C> status) throws TransactionException {
        this.commitInternal((InternalTransaction)status);
    }

    @Override
    public void rollback(TransactionStatus<C> status) throws TransactionException {
        this.rollbackInternal((InternalTransaction)status);
    }
}

