/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionOperationsRegistry;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import jakarta.inject.Singleton;

@Internal
@Singleton
final class DefaultTransactionOperationsRegistry
implements TransactionOperationsRegistry {
    private final BeanLocator beanLocator;

    DefaultTransactionOperationsRegistry(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    @Override
    public <T extends TransactionOperations<?>> T provideSynchronous(Class<T> transactionOperationsType, String dataSourceName) {
        if (dataSourceName == null) {
            try {
                return (T)((TransactionOperations)this.beanLocator.getBean(transactionOperationsType, null));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No backing TransactionOperations configured. Check your configuration and try again", (Throwable)e);
            }
        }
        try {
            return (T)((TransactionOperations)this.beanLocator.getBean(transactionOperationsType, Qualifiers.byName((String)dataSourceName)));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No backing TransactionOperations configured for datasource: [" + dataSourceName + "]. Check your configuration and try again", (Throwable)e);
        }
    }

    @Override
    public <T extends ReactiveTransactionOperations<?>> T provideReactive(Class<T> transactionOperationsType, String dataSourceName) {
        if (dataSourceName == null) {
            try {
                return (T)((ReactiveTransactionOperations)this.beanLocator.getBean(transactionOperationsType, null));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No reactive transaction management has been configured. Ensure you have correctly configured a reactive capable transaction manager");
            }
        }
        try {
            return (T)((ReactiveTransactionOperations)this.beanLocator.getBean(transactionOperationsType, Qualifiers.byName((String)dataSourceName)));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No reactive transaction management has been configured for datasource: [" + dataSourceName + "]. Ensure you have correctly configured a reactive capable transaction manager");
        }
    }

    @Override
    public <T extends AsyncTransactionOperations<?>> T provideAsync(Class<T> transactionOperationsType, String dataSourceName) {
        if (dataSourceName == null) {
            try {
                return (T)((AsyncTransactionOperations)this.beanLocator.getBean(transactionOperationsType, null));
            }
            catch (NoSuchBeanException e) {
                throw new ConfigurationException("No reactive transaction management has been configured. Ensure you have correctly configured a async capable transaction manager");
            }
        }
        try {
            return (T)((AsyncTransactionOperations)this.beanLocator.getBean(transactionOperationsType, Qualifiers.byName((String)dataSourceName)));
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No reactive transaction management has been configured for datasource: [" + dataSourceName + "]. Ensure you have correctly configured a async capable transaction manager");
        }
    }
}

