/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.aop.chain;

import io.micronaut.aop.Adapter;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.ExecutionHandle;
import io.micronaut.inject.qualifiers.Qualifiers;

@Internal
final class AdapterIntroduction
implements MethodInterceptor<Object, Object> {
    private final ExecutionHandle<?, ?> executionHandle;

    AdapterIntroduction(BeanContext beanContext, ExecutableMethod<?, ?> method) {
        Class[] methodArgumentTypes;
        AnnotationValue adapterAnnotationValue = method.getAnnotation(Adapter.class);
        if (adapterAnnotationValue == null) {
            throw new IllegalStateException("Adapter method must have @Adapter annotation");
        }
        Class beanType = adapterAnnotationValue.classValue("adaptedBean").orElse(null);
        if (beanType == null) {
            throw new IllegalStateException("No bean type to adapt found in Adapter configuration for method: " + String.valueOf(method));
        }
        String beanMethod = adapterAnnotationValue.stringValue("adaptedMethod").orElse(null);
        if (StringUtils.isEmpty((CharSequence)beanMethod)) {
            throw new IllegalStateException("No bean method to adapt found in Adapter configuration for method: " + String.valueOf(method));
        }
        String beanQualifier = adapterAnnotationValue.stringValue("adaptedQualifier").orElse(null);
        Class[] argumentTypes = adapterAnnotationValue.classValues("adaptedArgumentTypes");
        Class[] arguments = argumentTypes.length == (methodArgumentTypes = method.getArgumentTypes()).length ? argumentTypes : methodArgumentTypes;
        this.executionHandle = StringUtils.isNotEmpty((CharSequence)beanQualifier) ? (ExecutionHandle)beanContext.findExecutionHandle(beanType, Qualifiers.byName((String)beanQualifier), beanMethod, arguments).orElseThrow(() -> new IllegalStateException("Cannot adapt method [" + String.valueOf(method) + "]. Target method [" + beanMethod + "] not found on bean " + String.valueOf(beanType))) : (ExecutionHandle)beanContext.findExecutionHandle(beanType, beanMethod, arguments).orElseThrow(() -> new IllegalStateException("Cannot adapt method [" + String.valueOf(method) + "]. Target method [" + beanMethod + "] not found on bean " + String.valueOf(beanType)));
    }

    @Override
    @Nullable
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        return this.executionHandle.invoke(context.getParameterValues());
    }
}

