/*
 * Decompiled with CFR 0.152.
 */
package io.openshift.booster;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;

public class CopyFileVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetPath;
    private final Predicate<Path> filter;
    private Path sourcePath;

    public CopyFileVisitor(Path targetPath, Predicate<Path> filter) {
        this.targetPath = targetPath;
        this.filter = filter;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (!this.filter.test(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        } else {
            Path target = this.targetPath.resolve(this.sourcePath.relativize(dir));
            Files.createDirectories(target, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.filter.test(file)) {
            Path target = this.targetPath.resolve(this.sourcePath.relativize(file));
            Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
        }
        return FileVisitResult.CONTINUE;
    }
}

