/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class Config {
    private boolean overflowEnabled = true;
    private int heapPercentageThreshold = 80;
    private Optional<Path> storageLocation = Optional.empty();
    private boolean serializationStatsEnabled = false;
    private Optional<ExecutorService> executorService = Optional.empty();

    public static Config withDefaults() {
        return new Config();
    }

    public static Config withoutOverflow() {
        return Config.withDefaults().disableOverflow();
    }

    public Config disableOverflow() {
        this.overflowEnabled = false;
        return this;
    }

    public Config withHeapPercentageThreshold(int threshold) {
        this.heapPercentageThreshold = threshold;
        return this;
    }

    public Config withStorageLocation(Path path) {
        this.storageLocation = Optional.ofNullable(path);
        return this;
    }

    public Config withStorageLocation(String path) {
        return this.withStorageLocation(Paths.get(path, new String[0]));
    }

    public Config withSerializationStatsEnabled() {
        this.serializationStatsEnabled = true;
        return this;
    }

    public boolean isOverflowEnabled() {
        return this.overflowEnabled;
    }

    public int getHeapPercentageThreshold() {
        return this.heapPercentageThreshold;
    }

    public Optional<Path> getStorageLocation() {
        return this.storageLocation;
    }

    public boolean isSerializationStatsEnabled() {
        return this.serializationStatsEnabled;
    }

    public Config withExecutorService(ExecutorService executorService) {
        this.executorService = Optional.ofNullable(executorService);
        return this;
    }

    public Optional<ExecutorService> getExecutorService() {
        return this.executorService;
    }
}

