/*
 * Decompiled with CFR 0.152.
 */
package overflowdb;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import overflowdb.Direction;
import overflowdb.Element;
import overflowdb.Graph;
import overflowdb.NodeDb;
import overflowdb.NodeRef;
import overflowdb.Property;
import overflowdb.PropertyKey;
import overflowdb.util.IteratorUtils;

public abstract class Edge
extends Element {
    private final Graph graph;
    private final String label;
    private final NodeRef outNode;
    private final NodeRef inNode;
    private int outBlockOffset = -1;
    private int inBlockOffset = -1;
    private final Set<String> specificKeys;
    private boolean removed = false;
    private static final int UNINITIALIZED_BLOCK_OFFSET = -1;

    public Edge(Graph graph, String label, NodeRef outNode, NodeRef inVertex, Set<String> specificKeys) {
        this.graph = graph;
        this.label = label;
        this.outNode = outNode;
        this.inNode = inVertex;
        this.specificKeys = specificKeys;
        graph.applyBackpressureMaybe();
    }

    public NodeRef outNode() {
        return this.outNode;
    }

    public NodeRef inNode() {
        return this.inNode;
    }

    public Iterator<NodeRef> bothNodes() {
        return IteratorUtils.from(this.outNode, this.inNode);
    }

    public int getOutBlockOffset() {
        return this.outBlockOffset;
    }

    public void setOutBlockOffset(int offset) {
        this.outBlockOffset = offset;
    }

    public int getInBlockOffset() {
        return this.inBlockOffset;
    }

    public void setInBlockOffset(int offset) {
        this.inBlockOffset = offset;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.inBlockOffset != -1) {
            if (this.outBlockOffset == -1) {
                this.initializeOutFromInOffset();
            }
        } else if (this.outBlockOffset != -1) {
            if (this.inBlockOffset == -1) {
                this.initializeInFromOutOffset();
            }
        } else {
            throw new RuntimeException("Cannot set property. In and out block offset uninitialized.");
        }
        ((NodeDb)this.inNode.get()).setEdgeProperty(Direction.IN, this.label, key, (Object)value, this.inBlockOffset);
        ((NodeDb)this.outNode.get()).setEdgeProperty(Direction.OUT, this.label, key, (Object)value, this.outBlockOffset);
    }

    @Override
    public Set<String> propertyKeys() {
        return this.specificKeys;
    }

    @Override
    public void removeProperty(String key) {
        ((NodeDb)this.inNode.get()).removeEdgeProperty(Direction.IN, this.label, key, this.inBlockOffset);
        ((NodeDb)this.outNode.get()).removeEdgeProperty(Direction.OUT, this.label, key, this.outBlockOffset);
    }

    @Override
    public void remove() {
        this.fixupBlockOffsets();
        ((NodeDb)this.outNode.get()).removeEdge(Direction.OUT, this.label(), this.outBlockOffset);
        ((NodeDb)this.inNode.get()).removeEdge(Direction.IN, this.label(), this.inBlockOffset);
    }

    @Override
    public Map<String, Object> propertiesMap() {
        Map<String, Object> properties;
        if (this.inBlockOffset != -1) {
            properties = ((NodeDb)this.inNode.get()).edgePropertyMap(Direction.IN, this, this.getInBlockOffset());
        } else if (this.outBlockOffset != -1) {
            properties = ((NodeDb)this.outNode.get()).edgePropertyMap(Direction.OUT, this, this.getOutBlockOffset());
        } else {
            throw new RuntimeException("Cannot get properties. In and out block offset uninitialized.");
        }
        for (String key : this.propertyKeys()) {
            Object defaultValue;
            if (properties.containsKey(key) || (defaultValue = this.propertyDefaultValue(key)) == null) continue;
            properties.put(key, this.propertyDefaultValue(key));
        }
        return properties;
    }

    @Override
    public Object property(String propertyKey) {
        Object value;
        if (this.inBlockOffset != -1) {
            value = ((NodeDb)this.inNode.get()).edgeProperty(Direction.IN, this, this.inBlockOffset, propertyKey);
        } else if (this.outBlockOffset != -1) {
            value = ((NodeDb)this.outNode.get()).edgeProperty(Direction.OUT, this, this.outBlockOffset, propertyKey);
        } else {
            throw new RuntimeException("Cannot get property. In and out block offset unitialized.");
        }
        return value != null ? value : this.propertyDefaultValue(propertyKey);
    }

    @Override
    public <A> A property(PropertyKey<A> key) {
        return (A)this.property(key.name);
    }

    @Override
    public <A> Optional<A> propertyOption(PropertyKey<A> key) {
        return Optional.ofNullable(this.property(key));
    }

    @Override
    public Optional<Object> propertyOption(String key) {
        return Optional.ofNullable(this.property(key));
    }

    @Override
    public <A> void setProperty(PropertyKey<A> key, A value) {
        this.setProperty(key.name, value);
    }

    @Override
    public void setProperty(Property<?> property) {
        this.setProperty(property.key.name, property.value);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge otherEdge = (Edge)other;
        this.fixupBlockOffsetsIfNecessary(otherEdge);
        return !(this.inNode.id() != otherEdge.inNode.id() || this.outNode.id() != otherEdge.outNode.id() || !this.label.equals(otherEdge.label) || this.inBlockOffset != -1 && otherEdge.inBlockOffset != -1 && this.inBlockOffset != otherEdge.inBlockOffset || this.outBlockOffset != -1 && otherEdge.outBlockOffset != -1 && this.outBlockOffset != otherEdge.outBlockOffset);
    }

    public int hashCode() {
        return Objects.hash(this.inNode.id(), this.outNode.id(), this.label);
    }

    private void fixupBlockOffsetsIfNecessary(Edge otherEdge) {
        if (!(this.inBlockOffset != -1 && otherEdge.inBlockOffset != -1 || this.outBlockOffset != -1 && otherEdge.outBlockOffset != -1)) {
            this.fixupBlockOffsets();
        }
    }

    private void fixupBlockOffsets() {
        if (this.inBlockOffset == -1) {
            this.initializeInFromOutOffset();
        }
        if (this.outBlockOffset == -1) {
            this.initializeOutFromInOffset();
        }
    }

    private void initializeInFromOutOffset() {
        int edgeOccurenceForSameLabelEdgesBetweenSameNodePair = ((NodeDb)this.outNode.get()).blockOffsetToOccurrence(Direction.OUT, this.label(), this.inNode, this.outBlockOffset);
        this.inBlockOffset = ((NodeDb)this.inNode.get()).occurrenceToBlockOffset(Direction.IN, this.label(), this.outNode, edgeOccurenceForSameLabelEdgesBetweenSameNodePair);
    }

    private void initializeOutFromInOffset() {
        int edgeOccurenceForSameLabelEdgesBetweenSameNodePair = ((NodeDb)this.inNode.get()).blockOffsetToOccurrence(Direction.IN, this.label(), this.outNode, this.inBlockOffset);
        this.outBlockOffset = ((NodeDb)this.outNode.get()).occurrenceToBlockOffset(Direction.OUT, this.label(), this.inNode, edgeOccurenceForSameLabelEdgesBetweenSameNodePair);
    }
}

