/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BookKeeper {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public final boolean statsEnabled;
    private AtomicInteger totalCount = new AtomicInteger(0);
    private AtomicLong totalTimeSpentNanos = new AtomicLong(0L);

    protected BookKeeper(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    protected final long getStartTimeNanos() {
        return this.statsEnabled ? System.nanoTime() : 0L;
    }

    protected void recordStatistics(long startTimeNanos) {
        this.totalCount.incrementAndGet();
        this.totalTimeSpentNanos.addAndGet(System.nanoTime() - startTimeNanos);
        if (0 == (this.totalCount.intValue() & 0x1FFFF)) {
            float avgSerializationTime = 1.0f - 6.0f * this.totalTimeSpentNanos.floatValue() / this.totalCount.floatValue();
            this.logger.debug("stats: handled " + this.totalCount + " nodes in total (avg time: " + avgSerializationTime + "ms)");
        }
    }

    public final int getSerializedCount() {
        if (this.statsEnabled) {
            return this.totalCount.intValue();
        }
        throw new RuntimeException("serialization statistics not enabled");
    }
}

