/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.storage;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import overflowdb.AdjacentNodes;
import overflowdb.Node;
import overflowdb.NodeDb;
import overflowdb.NodeLayoutInformation;
import overflowdb.NodeRef;
import overflowdb.storage.BookKeeper;
import overflowdb.storage.OdbStorage;
import overflowdb.storage.ValueTypes;

public class NodeSerializer
extends BookKeeper {
    private final OdbStorage storage;
    private final Function<Object, Object> convertPropertyForPersistence;

    public NodeSerializer(boolean statsEnabled, OdbStorage storage, Function<Object, Object> convertPropertyForPersistence) {
        super(statsEnabled);
        this.storage = storage;
        this.convertPropertyForPersistence = convertPropertyForPersistence;
    }

    public NodeSerializer(boolean statsEnabled, OdbStorage storage) {
        this(statsEnabled, storage, Function.identity());
    }

    public byte[] serialize(NodeDb node) throws IOException {
        long startTimeNanos = this.getStartTimeNanos();
        try (MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();){
            NodeLayoutInformation layoutInformation = node.layoutInformation();
            node.markAsClean();
            packer.packLong(node.ref.id());
            int labelId = this.storage.lookupOrCreateStringToIntMapping(layoutInformation.label);
            packer.packInt(labelId);
            this.packProperties(packer, node.propertiesMapForStorage());
            this.packEdges(packer, node);
            if (this.statsEnabled) {
                this.recordStatistics(startTimeNanos);
            }
            byte[] byArray = packer.toByteArray();
            return byArray;
        }
    }

    private void packProperties(MessageBufferPacker packer, Map<String, Object> properties) throws IOException {
        packer.packMapHeader(properties.size());
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            int propertyKeyId = this.storage.lookupOrCreateStringToIntMapping(property.getKey());
            packer.packInt(propertyKeyId);
            Object valueMaybeConverted = this.convertPropertyForPersistence.apply(property.getValue());
            this.packTypedValue(packer, valueMaybeConverted);
        }
    }

    private void packEdges(MessageBufferPacker packer, NodeDb node) throws IOException {
        NodeLayoutInformation layoutInformation = node.layoutInformation();
        this.packEdgesForOneDirection(packer, node, node.getAdjacentNodes(), layoutInformation.allowedOutEdgeLabels(), layoutInformation::outEdgeToOffsetPosition);
        this.packEdgesForOneDirection(packer, node, node.getAdjacentNodes(), layoutInformation.allowedInEdgeLabels(), layoutInformation::inEdgeToOffsetPosition);
    }

    private void packEdgesForOneDirection(MessageBufferPacker packer, NodeDb node, AdjacentNodes adjacentNodes, String[] allowedEdgeLabels, Function<String, Integer> edgeToOffsetPosition) throws IOException {
        ArrayList<Object> edgeLabelAndOffsetPos = new ArrayList<Object>(allowedEdgeLabels.length * 2);
        int edgeTypeCount = 0;
        for (String edgeLabel : allowedEdgeLabels) {
            int offsetPos = edgeToOffsetPosition.apply(edgeLabel);
            int count = adjacentNodes.getOffset(offsetPos * 2 + 1);
            if (count <= 0) continue;
            ++edgeTypeCount;
            edgeLabelAndOffsetPos.add(edgeLabel);
            edgeLabelAndOffsetPos.add(offsetPos);
        }
        packer.packInt(edgeTypeCount);
        for (int i = 0; i < edgeLabelAndOffsetPos.size(); i += 2) {
            String edgeLabel = (String)edgeLabelAndOffsetPos.get(i);
            int offsetPos = (Integer)edgeLabelAndOffsetPos.get(i + 1);
            this.packEdgesForOneLabel(packer, node, adjacentNodes, edgeLabel, offsetPos);
        }
    }

    private void packEdgesForOneLabel(MessageBufferPacker packer, NodeDb node, AdjacentNodes adjacentNodes, String edgeLabel, int offsetPos) throws IOException {
        NodeLayoutInformation layoutInformation = node.layoutInformation();
        Object[] adjacentNodesWithEdgeProperties = adjacentNodes.nodesWithEdgeProperties;
        Set<String> edgePropertyNames = layoutInformation.edgePropertyKeys(edgeLabel);
        int start = node.startIndex(adjacentNodes, offsetPos);
        int blockLength = node.blockLength(adjacentNodes, offsetPos);
        int strideSize = node.getStrideSize(edgeLabel);
        ArrayList<Serializable> adjacentNodeIdsAndProperties = new ArrayList<Serializable>(blockLength / strideSize);
        int edgeCount = 0;
        int endIdx = start + blockLength;
        for (int currIdx = start; currIdx < endIdx; currIdx += strideSize) {
            Node adjacentNode = (Node)adjacentNodesWithEdgeProperties[currIdx];
            if (adjacentNode == null) continue;
            ++edgeCount;
            adjacentNodeIdsAndProperties.add(Long.valueOf(adjacentNode.id()));
            HashMap<String, Object> edgeProperties = new HashMap<String, Object>();
            for (String propertyName : edgePropertyNames) {
                int edgePropertyOffset = layoutInformation.getEdgePropertyOffsetRelativeToAdjacentNodeRef(edgeLabel, propertyName);
                Object property = adjacentNodesWithEdgeProperties[currIdx + edgePropertyOffset];
                if (property == null) continue;
                edgeProperties.put(propertyName, property);
            }
            adjacentNodeIdsAndProperties.add(edgeProperties);
        }
        int labelId = this.storage.lookupOrCreateStringToIntMapping(edgeLabel);
        packer.packInt(labelId);
        packer.packInt(edgeCount);
        for (int edgeIdx = 0; edgeIdx < edgeCount; ++edgeIdx) {
            long adjacentNodeId = (Long)adjacentNodeIdsAndProperties.get(edgeIdx * 2);
            packer.packLong(adjacentNodeId);
            Map edgeProperties = (Map)adjacentNodeIdsAndProperties.get(edgeIdx * 2 + 1);
            this.packProperties(packer, edgeProperties);
        }
    }

    private void packTypedValue(MessageBufferPacker packer, Object value) throws IOException {
        packer.packArrayHeader(2);
        if (value == null) {
            packer.packByte(ValueTypes.UNKNOWN.id);
            packer.packNil();
        } else if (value instanceof NodeRef) {
            packer.packByte(ValueTypes.NODE_REF.id);
            packer.packLong(((NodeRef)value).id());
        } else if (value instanceof Boolean) {
            packer.packByte(ValueTypes.BOOLEAN.id);
            packer.packBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            packer.packByte(ValueTypes.STRING.id);
            packer.packString((String)value);
        } else if (value instanceof Byte) {
            packer.packByte(ValueTypes.BYTE.id);
            packer.packByte(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            packer.packByte(ValueTypes.SHORT.id);
            packer.packShort(((Short)value).shortValue());
        } else if (value instanceof Integer) {
            packer.packByte(ValueTypes.INTEGER.id);
            packer.packInt(((Integer)value).intValue());
        } else if (value instanceof Long) {
            packer.packByte(ValueTypes.LONG.id);
            packer.packLong(((Long)value).longValue());
        } else if (value instanceof Float) {
            packer.packByte(ValueTypes.FLOAT.id);
            packer.packFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            packer.packByte(ValueTypes.DOUBLE.id);
            packer.packDouble(((Double)value).doubleValue());
        } else if (value instanceof Character) {
            packer.packByte(ValueTypes.CHARACTER.id);
            packer.packInt((int)((Character)value).charValue());
        } else if (value instanceof List) {
            packer.packByte(ValueTypes.ARRAY_OBJECT.id);
            List list = (List)value;
            packer.packArrayHeader(list.size());
            for (Object o : list) {
                this.packTypedValue(packer, o);
            }
        } else if (value instanceof Object[]) {
            packer.packByte(ValueTypes.ARRAY_OBJECT.id);
            Object[] array = (Object[])value;
            packer.packArrayHeader(array.length);
            for (Object o : array) {
                this.packTypedValue(packer, o);
            }
        } else if (value instanceof byte[]) {
            packer.packByte(ValueTypes.ARRAY_BYTE.id);
            byte[] array = (byte[])value;
            packer.packArrayHeader(array.length);
            for (byte b : array) {
                packer.packByte(b);
            }
        } else if (value instanceof short[]) {
            packer.packByte(ValueTypes.ARRAY_SHORT.id);
            short[] array = (short[])value;
            packer.packArrayHeader(array.length);
            for (short s : array) {
                packer.packShort(s);
            }
        } else if (value instanceof int[]) {
            packer.packByte(ValueTypes.ARRAY_INT.id);
            int[] array = (int[])value;
            packer.packArrayHeader(array.length);
            for (int i : array) {
                packer.packInt(i);
            }
        } else if (value instanceof long[]) {
            packer.packByte(ValueTypes.ARRAY_LONG.id);
            long[] array = (long[])value;
            packer.packArrayHeader(array.length);
            for (long l : array) {
                packer.packLong(l);
            }
        } else if (value instanceof float[]) {
            packer.packByte(ValueTypes.ARRAY_FLOAT.id);
            float[] array = (float[])value;
            packer.packArrayHeader(array.length);
            for (float f : array) {
                packer.packFloat(f);
            }
        } else if (value instanceof double[]) {
            packer.packByte(ValueTypes.ARRAY_DOUBLE.id);
            double[] array = (double[])value;
            packer.packArrayHeader(array.length);
            for (double d : array) {
                packer.packDouble(d);
            }
        } else if (value instanceof char[]) {
            packer.packByte(ValueTypes.ARRAY_CHAR.id);
            char[] array = (char[])value;
            packer.packArrayHeader(array.length);
            for (char c : array) {
                packer.packInt((int)c);
            }
        } else if (value instanceof boolean[]) {
            packer.packByte(ValueTypes.ARRAY_BOOL.id);
            boolean[] array = (boolean[])value;
            packer.packArrayHeader(array.length);
            for (boolean b : array) {
                packer.packBoolean(b);
            }
        } else {
            throw new UnsupportedOperationException("id type `" + value.getClass());
        }
    }
}

