/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayOffsetIterator<T>
implements Iterator<T> {
    private final Object[] array;
    private int current;
    private final int exclusiveEnd;
    private final int strideSize;
    private T nextCached;

    public ArrayOffsetIterator(Object[] array, int begin, int exclusiveEnd, int strideSize) {
        this.array = array;
        this.current = begin;
        this.exclusiveEnd = exclusiveEnd;
        this.strideSize = strideSize;
    }

    @Override
    public final boolean hasNext() {
        return this.peekNext() != null;
    }

    private T peekNext() {
        if (this.nextCached != null) {
            return this.nextCached;
        }
        if (this.current < this.exclusiveEnd) {
            this.nextCached = this.array[this.current];
            this.current += this.strideSize;
            return this.peekNext();
        }
        return null;
    }

    @Override
    public final T next() {
        if (this.hasNext()) {
            T ret = this.peekNext();
            this.nextCached = null;
            return ret;
        }
        throw new NoSuchElementException();
    }
}

