/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.util;

import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.slf4j.MDC;

public class NamedThreadFactory
implements ThreadFactory {
    private final String threadName;
    private final Map<String, String> mdc = MDC.getCopyOfContextMap();

    public NamedThreadFactory(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(() -> {
            MDC.setContextMap(this.mdc);
            r.run();
        }, this.threadName);
    }
}

