/*
 * Decompiled with CFR 0.152.
 */
package ir.kavoshgaran.bitrah.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import ir.kavoshgaran.bitrah.entities.AcceptedLanguage;
import ir.kavoshgaran.bitrah.entities.AuthenticateModel;
import ir.kavoshgaran.bitrah.entities.Coin;
import ir.kavoshgaran.bitrah.entities.Order;
import ir.kavoshgaran.bitrah.entities.OrdersRequest;
import ir.kavoshgaran.bitrah.exception.BitrahErrorResponse;
import ir.kavoshgaran.bitrah.exception.BitrahException;
import ir.kavoshgaran.bitrah.exception.BitrahUnAuthorizedException;
import ir.kavoshgaran.bitrah.responses.BitrahLoginResponse;
import ir.kavoshgaran.bitrah.responses.BitrahStatusResponse;
import ir.kavoshgaran.bitrah.responses.BitrahSubmitOrderResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class BitrahClient {
    private static final String BASE_URL = "https://api.bitrah.ir/api/v1";
    private String merchantId;
    private String callBackUrl;
    private String webHookUrl;
    private String username;
    private String password;
    private String token;
    private AcceptedLanguage acceptedLanguage;
    private final String AUTHORIZATION_KEY = "Authentication";
    private String expiredTime;

    public BitrahClient(String merchantId, String callBackUrl, String webHookUrl, AcceptedLanguage acceptedLanguage, String username, String password) {
        this.merchantId = merchantId;
        this.callBackUrl = callBackUrl;
        this.webHookUrl = webHookUrl;
        this.acceptedLanguage = acceptedLanguage;
        this.username = username;
        this.password = password;
    }

    public BitrahSubmitOrderResponse submitOrder(String orderId, Long rialValue, Coin coin) {
        this.tokenValidation();
        String submitOrderUrl = "https://api.bitrah.ir/api/v1/order/submit/wr";
        Order order = new Order();
        order.setMerchantId(this.merchantId);
        order.setOrderId(orderId);
        order.setRialValue(rialValue);
        order.setCallbackUrl(this.callBackUrl);
        order.setWebhookUrl(this.webHookUrl);
        if (coin != null) {
            order.setCoin(coin.getIso());
        }
        BitrahSubmitOrderResponse response = null;
        try {
            Mono bodyMono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create().post().uri(submitOrderUrl, new Object[0])).header("Accepted-Language", new String[]{this.acceptedLanguage.getLanguage()})).contentType(MediaType.APPLICATION_JSON).header("Authentication", new String[]{"bearer " + this.token})).body(BodyInserters.fromObject((Object)order)).retrieve().bodyToMono(BitrahSubmitOrderResponse.class);
            response = (BitrahSubmitOrderResponse)bodyMono.block();
        }
        catch (WebClientResponseException e) {
            this.handleBitrahResponseException(e);
        }
        return response;
    }

    public BitrahStatusResponse orderStatus(Long refId) {
        this.tokenValidation();
        String submitOrderUrl = "https://api.bitrah.ir/api/v1/order/status/rd";
        OrdersRequest ordersRequest = new OrdersRequest();
        ordersRequest.setMerchantId(this.merchantId);
        ordersRequest.setRefId(refId);
        BitrahStatusResponse response = null;
        try {
            Mono bodyMono = ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create().post().uri(submitOrderUrl, new Object[0])).header("Accept-Language", new String[]{this.acceptedLanguage.getLanguage()})).header("Authentication", new String[]{"bearer " + this.token})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromObject((Object)ordersRequest)).retrieve().bodyToMono(BitrahStatusResponse.class);
            response = (BitrahStatusResponse)bodyMono.block();
        }
        catch (WebClientResponseException e) {
            this.handleBitrahResponseException(e);
        }
        return response;
    }

    private void tokenValidation() {
        LocalDateTime expireDateTime;
        if (StringUtils.isEmpty((Object)this.token)) {
            this.loginMerchant();
        } else if (this.expiredTime != null && (expireDateTime = LocalDateTime.parse(this.expiredTime, DateTimeFormatter.ofPattern("yyyy/M/dd HH:mm:ss"))).until(LocalDateTime.now(), ChronoUnit.MINUTES) >= 0L) {
            this.loginMerchant();
        }
        if (this.token == null) {
            throw new BitrahUnAuthorizedException("Jwt token is null");
        }
    }

    public void loginMerchant() {
        if (StringUtils.isEmpty((Object)this.username) || StringUtils.isEmpty((Object)this.password)) {
            throw new BitrahException("UserName or password is empty.", HttpStatus.UNAUTHORIZED.value());
        }
        String loginUrl = "https://api.bitrah.ir/api/v1/authentication/login";
        AuthenticateModel authenticateModel = new AuthenticateModel(this.username, this.password);
        try {
            BitrahLoginResponse loginResponse = (BitrahLoginResponse)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WebClient.create().post().uri(loginUrl, new Object[0])).header("Accepted-Language", new String[]{this.acceptedLanguage.getLanguage()})).contentType(MediaType.APPLICATION_JSON).body(BodyInserters.fromObject((Object)authenticateModel)).retrieve().bodyToMono(BitrahLoginResponse.class).block();
            if (loginResponse != null && Boolean.TRUE.equals(loginResponse.getSuccess())) {
                this.token = loginResponse.getData().getToken();
                this.expiredTime = loginResponse.getData().getExpireDate();
            }
        }
        catch (WebClientResponseException e) {
            this.handleBitrahResponseException(e);
        }
    }

    private void handleBitrahResponseException(WebClientResponseException e) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            BitrahErrorResponse bitrahError = (BitrahErrorResponse)mapper.readValue(e.getResponseBodyAsByteArray(), BitrahErrorResponse.class);
            throw new BitrahException(bitrahError.getData().getMessage(), bitrahError.getData().getCode());
        }
        catch (IOException ioException) {
            e.printStackTrace();
            return;
        }
    }
}

