package ir.dorantech.stepcounter

import android.content.Context
import androidx.activity.compose.ManagedActivityResultLauncher
import androidx.activity.result.ActivityResultLauncher
import androidx.compose.runtime.Composable
import ir.dorantech.permissionkit.main.PermissionKitFactory
import ir.dorantech.permissionkit.main.di.Permissions
import kotlin.Array
import kotlin.String

@Suppress("unused")
class PermissionApi(context: Context, val servicePermissions: Array<Permissions>) {
    val permissionKit = PermissionKitFactory.Companion.create(context)

    suspend fun onRequestServicePermissions(
        registerForActivityResult: ActivityResultLauncher<Array<String>>
    ) {
        permissionKit.onRequestPermissions(
            servicePermissions,
            registerForActivityResult
        )
    }

    @Composable
    fun OnRequestServicePermission(
        permissionLauncher: ManagedActivityResultLauncher<Array<String>, Map<String, Boolean>>
    ) {
        permissionKit.OnRequestPermission(
            servicePermissions,
            permissionLauncher
        )
    }

    suspend fun onRequestPermissions(
        permissionArray: Array<Permissions>,
        registerForActivityResult: ActivityResultLauncher<Array<String>>
    ) {
        permissionKit.onRequestPermissions(
            permissionArray,
            registerForActivityResult
        )
    }

    @Composable
    fun OnRequestPermissions(
        permissionArray: Array<Permissions>,
        permissionLauncher: ManagedActivityResultLauncher<Array<String>, Map<String, Boolean>>
    ) {
        permissionKit.OnRequestPermission(
            permissionArray,
            permissionLauncher
        )
    }
}