package ir.dorantech.stepcounter.countermodule

import android.content.Context
import android.content.Intent
import ir.dorantech.stepcounter.domain.usecase.GetTotalStepsUseCase
import ir.dorantech.stepcounter.domain.usecase.SetTotalStepsUseCase
import ir.dorantech.stepcounter.foundation.tools.LogManager
import ir.dorantech.stepcounter.service.ActivityMonitorService
import ir.dorantech.stepcounter.worker.ServiceMonitorScheduler
import kotlinx.coroutines.flow.Flow
import org.kodein.di.DI
import org.kodein.di.instance

class ServiceCommand internal constructor(private val context: Context, appDi: DI) {

    private val getTotalStepsUseCase: GetTotalStepsUseCase by appDi.instance()
    private val setTotalStepsUseCase: SetTotalStepsUseCase by appDi.instance()
    private val logManager: LogManager by appDi.instance()

    fun startService() {
        logManager.addLog("startService is called")
        ServiceMonitorScheduler.scheduleWorker(context.applicationContext)
    }

    fun stopService() {
        val serviceIntent = Intent(context, ActivityMonitorService::class.java)
        context.stopService(serviceIntent)
        ServiceMonitorScheduler.cancelScheduledWork(context)
    }

    fun readStepsCount(): Flow<Long> {
        return getTotalStepsUseCase()
    }

    suspend fun resetCounter() {
        setTotalStepsUseCase(0)
    }
}