package ir.dorantech.stepcounter.internal

import android.content.Context
import ir.dorantech.stepcounter.di.CombineDi
import ir.dorantech.permissionkit.main.PermissionKitFactory
import ir.dorantech.permissionkit.main.di.Permissions
import ir.dorantech.stepcounter.PermissionApi
import ir.dorantech.stepcounter.ServiceApi
import ir.dorantech.stepcounter.foundation.di.AppDi
import ir.dorantech.stepcounter.model.StepCounterResult

internal class InitStepsCounterService(
    private val context: Context,
) {
    val permissionKit = PermissionKitFactory.create(context)
    val neededPermissions = arrayOf(
        Permissions.ACCESS_COARSE_LOCATION,
        Permissions.ACCESS_FINE_LOCATION,
        Permissions.ACTIVITY_RECOGNITION,
//        Permissions.BATTERY_OPTIMIZATION,
//        Permissions.AUTO_START,
        Permissions.POST_NOTIFICATIONS,
    )

    fun init(): StepCounterResult {
        CombineDi.init(context)
        return if (permissionKit.areConditionsMet(neededPermissions))
            StepCounterResult.Success(ServiceApi(context, AppDi.di))
        else StepCounterResult.PermissionDenied(PermissionApi(context, neededPermissions))
    }
}