@file:Suppress("unused")
package ir.dorantech.stepcounter.model

import ir.dorantech.stepcounter.ServiceApi
import ir.dorantech.stepcounter.model.StepCounterResult.PermissionDenied
import ir.dorantech.stepcounter.model.StepCounterResult.Success

sealed interface StepCounterResult {
    data class Success(val serviceApi: ServiceApi) : StepCounterResult
    data class PermissionDenied(val deniedPermissions: List<String>) : StepCounterResult
    data class Error(val exception: Exception) : StepCounterResult
}

val StepCounterResult.isSuccess: Boolean
    get() = this is Success

val StepCounterResult.isPermissionRequired: Boolean
    get() = this is PermissionDenied

val StepCounterResult.isFailure: Boolean
    get() = this is StepCounterResult.Error

inline fun StepCounterResult.onSuccess(block: (ServiceApi) -> Unit): StepCounterResult {
    if (this is Success) block(this.serviceApi)
    return this
}

inline fun StepCounterResult.onPermissionRequired(block: (List<String>) -> Unit): StepCounterResult {
    if (this is PermissionDenied) block(this.deniedPermissions)
    return this
}

inline fun StepCounterResult.onFailure(block: (Exception) -> Unit): StepCounterResult {
    if (this is StepCounterResult.Error) block(this.exception)
    return this
}