package ir.dorantech.stepcounter.internal

import android.Manifest.permission.*
import android.content.Context
import ir.dorantech.stepcounter.di.CombineDi
import ir.dorantech.stepcounter.StepCounterServiceApi
import ir.dorantech.stepcounter.domain.usecase.PermissionUseCase
import ir.dorantech.stepcounter.foundation.di.AppDIAware
import ir.dorantech.stepcounter.foundation.di.AppDi
import ir.dorantech.stepcounter.foundation.tools.LogManager
import ir.dorantech.stepcounter.model.StepCounterResult
import org.kodein.di.instance

internal class InitStepsCounterService(
    private val context: Context,
) : AppDIAware {
    val permissionUserCase by instance<PermissionUseCase>()
    val logManager by instance<LogManager>()
    val neededPermissions = arrayOf(
        ACCESS_COARSE_LOCATION,
        ACCESS_FINE_LOCATION,
        ACTIVITY_RECOGNITION,
//        AUTO_START,
        POST_NOTIFICATIONS,
    )

    fun init(): StepCounterResult {
        CombineDi.init(context)

        val permissionDenied = permissionUserCase.checkPermissionsGranted(neededPermissions)
        val isBatteryOptimizationDisable = permissionUserCase.checkBatteryOptimization()
        if (isBatteryOptimizationDisable.not()) permissionDenied.add("BATTERY_OPTIMIZATION")
        return if (permissionDenied.isEmpty()) {
            logManager.addLog("Service initialized successfully.")
            StepCounterResult.Success(StepCounterServiceApi(context, AppDi.di))
        } else {
            permissionDenied.forEach { permission ->
                logManager.addLog("service initialization failed due to $permission denied.")
            }
            StepCounterResult.PermissionDenied(permissionDenied)
        }
    }
}