/*
	PersianCalendarConstants.java
	2005-02-20 13:53:05
	Copyright C Ghasem Kiani <ghasemkiani@yahoo.com>
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

package com.ghasemkiani.util;

/**
	This class contains some constants used in other Persian Calendar 
	classes.
	
	@author <a href="mailto:ghasemkiani@yahoo.com">Ghasem Kiani</a>
	@version 2.1
*/
public interface PersianCalendarConstants
{
	/**
		Constant for Farvardin, the 1st month of the Persian year.
	*/
	public static final int FARVARDIN = 0;
	/**
		Constant for Ordibehesht, the 2nd month of the Persian year.
	*/
	public static final int ORDIBEHESHT = 1;
	/**
		Constant for Khordad, the 3rd month of the Persian year.
	*/
	public static final int KHORDAD = 2;
	/**
		Constant for Tir, the 4th month of the Persian year.
	*/
	public static final int TIR = 3;
	/**
		Constant for Mordad, the 5th month of the Persian year.
	*/
	public static final int MORDAD = 4;
	/**
		Constant for Shahrivar, the 6th month of the Persian year.
	*/
	public static final int SHAHRIVAR = 5;
	/**
		Constant for Mehr, the 7th month of the Persian year.
	*/
	public static final int MEHR = 6;
	/**
		Constant for Aban, the 8th month of the Persian year.
	*/
	public static final int ABAN = 7;
	/**
		Constant for Azar, the 9th month of the Persian year.
	*/
	public static final int AZAR = 8;
	/**
		Constant for Dey, the 10th month of the Persian year.
	*/
	public static final int DEY = 9;
	/**
		Constant for Bahman, the 11th month of the Persian year.
	*/
	public static final int BAHMAN = 10;
	/**
		Constant for Esfand, the 12th month of the Persian year.
	*/
	public static final int ESFAND = 11;
	
}
