package ir.map.sdk_map.utils;

import android.graphics.Color;

import androidx.annotation.Keep;

import java.util.Arrays;
import java.util.List;

@Keep
public class VectorUtils {
    //region lightLogoPathList
    public static final List<VectorDrawableCreator.PathData> lightLogoPathList = Arrays.asList(
            new VectorDrawableCreator.PathData("M103.476,15.41h-3.53a6.15,6.15 0,0 0,-2.406 0.489,6.4 6.4,0 0,0 -2,1.336A6.194,6.194 0,0 0,94.2 19.2a6.03,6.03 0,0 0,-0.492 2.444V27.9h3.833v-6.26a2.391,2.391 0,0 1,1.48 -2.241,2.331 2.331,0 0,1 0.905,-0.186h0.246a3.311,3.311 0,0 0,3.307 -3.306v-0.5Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M93.039,15.411H88.963V27.9h4.076V15.411Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M91.006,10.714h0a2.155,2.155 0,1 0,2.155 2.155A2.157,2.157 0,0 0,91 10.714Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M84.73,21.487a3.221,3.221 0,0 0,-1.246 0.251,3.061 3.061,0 0,0 -1.021,0.7 3.224,3.224 0,0 0,-0.68 1.008,3.186 3.186,0 0,0 -0.255,1.249V27.9h3.2a3.147,3.147 0,0 0,1.244 -0.255A3.2,3.2 0,0 0,87 26.957a3.166,3.166 0,0 0,0.694 -1.03,3.2 3.2,0 0,0 0,-2.491 3.243,3.243 0,0 0,-1.718 -1.7,3.221 3.221,0 0,0 -1.246,-0.251Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M48.448,15.41A6.205,6.205 0,0 0,44.1 17.185,6.328 6.328,0 0,0 42.61,16.1a6.069,6.069 0,0 0,-2.8 -0.687h-0.071a6.148,6.148 0,0 0,-2.418 0.49,6.316 6.316,0 0,0 -1.985,1.335 6.153,6.153 0,0 0,-1.333 1.971,6.058 6.058,0 0,0 -0.491,2.441V27.91h3.807V21.644a2.428,2.428 0,0 1,0.186 -0.942,2.456 2.456,0 0,1 0.521,-0.778 2.391,2.391 0,0 1,0.771 -0.52,2.495 2.495,0 0,1 1.905,0A2.412,2.412 0,0 1,42.01 20.7a2.337,2.337 0,0 1,0.186 0.935V27.9H46V21.644A2.414,2.414 0,0 1,47.488 19.4a2.25,2.25 0,0 1,0.9 -0.186,2.51 2.51,0 0,1 1.789,0.711 2.423,2.423 0,0 1,0.517 0.773,2.349 2.349,0 0,1 0.186,0.937V27.9H54.69v-6.26a6.182,6.182 0,0 0,-1.827 -4.411A6.344,6.344 0,0 0,50.87 15.9a6.2,6.2 0,0 0,-2.422 -0.49Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M61.62,15.4a6.214,6.214 0,0 0,-2.427 0.491A6.446,6.446 0,0 0,57.2 17.224a6.194,6.194 0,0 0,-1.352 6.84,6.206 6.206,0 0,0 1.348,2 6.555,6.555 0,0 0,1.991 1.345,6.2 6.2,0 0,0 2.431,0.492h6.229L67.847,21.65a6.155,6.155 0,0 0,-0.5 -2.444,6.507 6.507,0 0,0 -1.328,-1.975 6.4,6.4 0,0 0,-1.97 -1.334A6.219,6.219 0,0 0,61.62 15.4ZM61.62,24.1a2.6,2.6 0,0 1,-0.964 -0.188,2.493 2.493,0 0,1 -0.78,-0.517 2.278,2.278 0,0 1,-0.508 -0.775,2.385 2.385,0 0,1 -0.19,-0.956 2.419,2.419 0,0 1,0.186 -0.949,2.563 2.563,0 0,1 0.522,-0.785 2.444,2.444 0,0 1,3.449 0.007,2.279 2.279,0 0,1 0.518,0.771 2.35,2.35 0,0 1,0.189 0.943l0,2.449Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M74.749,15.409A6.244,6.244 0,0 0,69 19.209a6.038,6.038 0,0 0,-0.49 2.439L68.51,34.481h0.5a3.311,3.311 0,0 0,3.307 -3.307L72.317,27.9h2.428a6.071,6.071 0,0 0,2.432 -0.491,6.293 6.293,0 0,0 3.332,-3.343 6.176,6.176 0,0 0,-1.353 -6.843A6.487,6.487 0,0 0,77.18 15.9a6.214,6.214 0,0 0,-2.431 -0.493ZM72.366,24.119L72.366,21.665a2.414,2.414 0,0 1,1.485 -2.241,2.339 2.339,0 0,1 0.906,-0.186 2.623,2.623 0,0 1,1 0.189,2.4 2.4,0 0,1 1.489,2.233 2.665,2.665 0,0 1,-0.194 0.977,2.535 2.535,0 0,1 -0.521,0.783 2.293,2.293 0,0 1,-0.77 0.509,2.418 2.418,0 0,1 -0.931,0.19Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M15.807,0.158H15.32a15.012,15.012 0,0 0,-4.049 0.6h-0.045L11.144,0.79l-0.09,0.027a1.193,1.193 0,0 0,-0.114 0.037L10.9,0.863l-0.036,0.016 -0.006,0h-0.006l-0.085,0.025A15.233,15.233 0,0 0,0.921 11.1a0.851,0.851 0,0 0,-0.035 0.122,14.876 14.876,0 0,0 -0.568,4.094A15.188,15.188 0,0 0,5.286 26.593l9.86,9.86 0.354,0.354 0.353,-0.354 9.64,-9.644A15.195,15.195 0,0 0,15.812 0.158Z",
                    Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M52.509,17.586a5.87,5.87 0,0 0,-1.833 -1.225,5.732 5.732,0 0,0 -4.848,0.183 5.812,5.812 0,0 0,-1.734 1.372,5.838 5.838,0 0,0 -1.717,-1.372 5.526,5.526 0,0 0,-2.629 -0.628,5.65 5.65,0 0,0 -2.23,0.45A5.821,5.821 0,0 0,35.69 17.6a5.675,5.675 0,0 0,-1.225 1.811,5.587 5.587,0 0,0 -0.451,2.242v5.76h2.807V21.644a2.927,2.927 0,0 1,1.786 -2.7,2.993 2.993,0 0,1 2.288,0A2.9,2.9 0,0 1,42.471 20.5a2.823,2.823 0,0 1,0.225 1.136V27.4H45.5V21.644a2.911,2.911 0,0 1,0.225 -1.136,2.942 2.942,0 0,1 1.566,-1.566 2.757,2.757 0,0 1,1.136 -0.225,2.994 2.994,0 0,1 2.1,0.854 2.907,2.907 0,0 1,0.628 0.937,2.823 2.823,0 0,1 0.225,1.136V27.4H54.19v-5.76a5.676,5.676 0,0 0,-1.681 -4.058Z",
                    Color.parseColor("#2e0767")),
            new VectorDrawableCreator.PathData("M66.89,19.4a6.023,6.023 0,0 0,-1.225 -1.822,5.924 5.924,0 0,0 -1.812,-1.225 5.739,5.739 0,0 0,-4.466 0,5.98 5.98,0 0,0 -1.838,1.225A5.852,5.852 0,0 0,56.308 19.4a5.757,5.757 0,0 0,1.241 6.31,6.07 6.07,0 0,0 1.838,1.241 5.725,5.725 0,0 0,2.23 0.45h5.729L67.346,21.65A5.685,5.685 0,0 0,66.89 19.4ZM64.545,24.605L61.617,24.605a3.066,3.066 0,0 1,-1.152 -0.225,3 3,0 0,1 -0.942,-0.623 2.786,2.786 0,0 1,-0.623 -0.948,2.855 2.855,0 0,1 -0.225,-1.147 2.911,2.911 0,0 1,0.225 -1.136,2.875 2.875,0 0,1 1.565,-1.566 2.933,2.933 0,0 1,3.221 0.629,2.755 2.755,0 0,1 0.628,0.937 2.823,2.823 0,0 1,0.225 1.136Z",
                    Color.parseColor("#2e0767")),
            new VectorDrawableCreator.PathData("M80.05,19.4a5.528,5.528 0,0 0,-1.241 -1.812,5.991 5.991,0 0,0 -1.827,-1.225 5.746,5.746 0,0 0,-7.52 3.042,5.6 5.6,0 0,0 -0.45,2.241L69.012,33.981a2.807,2.807 0,0 0,2.807 -2.807h0L71.819,27.4h2.927a5.541,5.541 0,0 0,2.236 -0.45,5.826 5.826,0 0,0 3.068,-3.079 5.781,5.781 0,0 0,0 -4.477ZM77.516,22.825a3.034,3.034 0,0 1,-0.628 0.947,2.79 2.79,0 0,1 -0.943,0.623 2.914,2.914 0,0 1,-1.152 0.226L71.866,24.621L71.866,21.665a2.911,2.911 0,0 1,0.225 -1.136,2.942 2.942,0 0,1 1.566,-1.566 2.84,2.84 0,0 1,1.136 -0.225,3.082 3.082,0 0,1 1.152,0.225 2.915,2.915 0,0 1,1.8 2.7,3.147 3.147,0 0,1 -0.23,1.163Z",
                    Color.parseColor("#2e0767")),
            new VectorDrawableCreator.PathData("M86.651,22.781a2.792,2.792 0,0 0,-0.869 -0.582,2.725 2.725,0 0,0 -2.1,0 2.584,2.584 0,0 0,-0.853 0.582,2.756 2.756,0 0,0 -0.582,0.858 2.715,2.715 0,0 0,-0.214 1.053V27.4h2.7a2.664,2.664 0,0 0,1.047 -0.214,2.707 2.707,0 0,0 0.869,-0.587 2.638,2.638 0,0 0,0.587 -0.869,2.725 2.725,0 0,0 0,-2.105A2.781,2.781 0,0 0,86.651 22.781Z",
                    Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M99.965,15.911a5.673,5.673 0,0 0,-2.231 0.45,5.907 5.907,0 0,0 -1.838,1.23A5.737,5.737 0,0 0,94.655 19.4a5.6,5.6 0,0 0,-0.45 2.241V27.4h2.833v-5.76a2.906,2.906 0,0 1,0.22 -1.136,2.937 2.937,0 0,1 1.565,-1.566 2.862,2.862 0,0 1,1.137 -0.225h0.209a2.806,2.806 0,0 0,2.807 -2.806h0S100.718,15.913 99.965,15.911Z",
                    Color.parseColor("#2e0767")),
            new VectorDrawableCreator.PathData("M89.463,15.911h3.075v11.494h-3.075z",
                    Color.parseColor("#2e0767")),
            new VectorDrawableCreator.PathData("M91,11.214a1.655,1.655 0,1 0,1.655 1.655h0a1.654,1.654 0,0 0,-1.65 -1.655Z",
                    Color.parseColor("#2e0767")),
            new VectorDrawableCreator.PathData("M30.209,15.349a14.661,14.661 0,0 1,-5.07 11.106L15.5,36.1 5.623,26.224a14.8,14.8 0,0 1,-2.847 -3.539A14.641,14.641 0,0 1,0.818 15.349v-0.033a14.378,14.378 0,0 1,0.558 -3.987v-0.005a0.269,0.269 0,0 1,0.019 -0.061,14.735 14.735,0 0,1 9.531,-9.881h0.009c0.043,-0.014 0.085,-0.025 0.128,-0.043l0.057,-0.019c0.024,-0.009 0.052,-0.014 0.08,-0.025l0.109,-0.033a0.085,0.085 0,0 1,0.038 -0.009A14.484,14.484 0,0 1,15.32 0.658H15.8A14.684,14.684 0,0 1,30.209 15.349Z",
                    Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M27.193,13.726a3.041,3.041 0,0 0,-0.321 -0.279,3.941 3.941,0 0,0 -2.422,-0.823 3.849,3.849 0,0 0,-0.416 0.019l-0.525,-0.611A3.789,3.789 0,0 0,24.246 7c-0.071,-0.066 -0.151,-0.132 -0.231,-0.194a3.962,3.962 0,0 0,-2.441 -0.837A3.9,3.9 0,0 0,18.3 7.691a3.509,3.509 0,0 0,-0.137 -0.961h0a3.729,3.729 0,0 0,-0.573 -1.187,3.913 3.913,0 0,0 -1.054,-0.994 4,4 0,0 0,-2.923 -0.525,3.837 3.837,0 0,0 -2.45,1.637A3.671,3.671 0,0 0,10.62 8.5c0.033,0.132 0.066,0.26 0.109,0.387 -0.052,-0.042 -0.109,-0.08 -0.165,-0.118a3.983,3.983 0,0 0,-3.458 -0.52,3.81 3.81,0 0,0 -2.261,1.878 3.715,3.715 0,0 0,-0.42 1.49A3.751,3.751 0,0 0,5.984 14.3a3.967,3.967 0,0 0,0.857 0.458l0.075,0.6a4,4 0,0 0,-1.338 0.558,3.767 3.767,0 0,0 -1.7,2.838 3.79,3.79 0,0 0,5.676 2.976l0.156,0.572a3.653,3.653 0,0 0,0.109 3.566,3.846 3.846,0 0,0 2.36,1.76 4.012,4.012 0,0 0,2.952 -0.379,3.758 3.758,0 0,0 1.892,-2.653c0,-0.01 0,-0.025 0,-0.038 0.019,0.047 0.048,0.09 0.067,0.132a3.855,3.855 0,0 0,2.861 2.034,4.536 4.536,0 0,0 0.615,0.048 3.973,3.973 0,0 0,2.28 -0.719,3.748 3.748,0 0,0 1.556,-2.46 3.848,3.848 0,0 0,-1.2 -3.467,3.426 3.426,0 0,0 -0.487,-0.369c0.1,0.047 0.2,0.09 0.3,0.132a4.034,4.034 0,0 0,1.437 0.265,3.935 3.935,0 0,0 2.747,-1.1 3.68,3.68 0,0 0,1.14 -2.663A3.758,3.758 0,0 0,27.193 13.726Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M26.87,13.446a2.7,2.7 0,0 0,-0.293 -0.321,3.767 3.767,0 0,0 -1.977,-1.04 3.854,3.854 0,0 0,-0.7 -0.061,3.613 3.613,0 0,0 -0.4,0.019 3.785,3.785 0,1 0,-4.8 -5.852,3.849 3.849,0 0,0 -0.54,0.543h0c-0.085,0.1 -0.165,0.218 -0.241,0.332a3.912,3.912 0,0 0,-0.326 -1.519,3.781 3.781,0 0,0 -7.151,2.328c0.033,0.132 0.062,0.265 0.1,0.392a1.9,1.9 0,0 0,-0.161 -0.118A3.785,3.785 0,0 0,5.978 14.3a3.939,3.939 0,0 0,0.856 0.458,3.932 3.932,0 0,0 -0.68,0.218 4.025,4.025 0,0 0,-0.625 0.341,3.783 3.783,0 0,0 4.02,6.4 3.918,3.918 0,0 0,-0.284 0.785,3.833 3.833,0 0,0 0.085,2.128 3.5,3.5 0,0 0,0.308 0.677A3.78,3.78 0,0 0,16.668 24a4.257,4.257 0,0 0,0.336 0.6c0.025,0.037 0.048,0.066 0.072,0.1a3.755,3.755 0,0 0,2.445 1.481,4.393 4.393,0 0,0 0.6,0.047 3.778,3.778 0,0 0,3.731 -3.188,3.941 3.941,0 0,0 -0.662,-2.9c-0.057,-0.081 -0.119,-0.161 -0.18,-0.237a3.489,3.489 0,0 0,-0.8 -0.71,3.791 3.791,0 0,0 4.663,-5.746Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M23.9,12.978A2.8,2.8 0,0 1,25.9 13.8a3.293,3.293 0,0 1,0.3 0.355,2.822 2.822,0 0,1 -4.29,3.638l-0.7,-0.7L19.836,18.47a0.989,0.989 0,0 1,-0.26 0.184,1.3 1.3,0 0,1 -1.433,-0.124c-0.038,-0.033 -0.071,-0.061 -0.109,-0.1l-0.378,-0.378 0.819,-0.818q0.03,-0.032 0.057,-0.066l1.244,-1.244 1.277,-1.277 0.837,-0.837a2.862,2.862 0,0 1,2.015 -0.833Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M20.8,6.309c0.1,-0.009 0.2,-0.014 0.3,-0.014a2.821,2.821 0,0 1,0.288 5.628l-0.979,0.1 0.2,1.925a1.023,1.023 0,0 1,-0.019 0.317,1.291 1.291,0 0,1 -1.135,1.056l-0.194,0.019 -0.335,0.038 -0.124,-1.15c0,-0.033 -0.01,-0.057 -0.015,-0.085l-0.5,-4.74a2.812,2.812 0,0 1,2.493 -3.1h0s0.009,0 0.009,0Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M17.822,10.722a1.3,1.3 0,0 1,0.109 1.547l-0.293,0.445 -0.966,-0.629a0.412,0.412 0,0 1,-0.075 -0.047L12.605,9.445a2.82,2.82 0,0 1,-0.829 -3.9h0a2.821,2.821 0,0 1,5.189 1.532,2.859 2.859,0 0,1 -0.455,1.537l-0.534,0.828 0.515,0.336L17.6,10.5a2.892,2.892 0,0 1,0.217 0.227Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M5.667,9.942a2.819,2.819 0,0 1,5.192 0.411l0.308,0.94 1.839,-0.6a0.984,0.984 0,0 1,0.28 -0.047h0.071a1.286,1.286 0,0 1,1.229 0.894l0.067,0.213 0.1,0.3 -1.1,0.362a0.475,0.475 0,0 0,-0.081 0.033l-4.522,1.47A2.822,2.822 0,0 1,5.5 12.108c-0.038,-0.128 -0.071,-0.255 -0.1,-0.383a2.891,2.891 0,0 1,0.265 -1.783Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M5.013,17.438A2.822,2.822 0,0 1,8.66 15.82l0.922,0.356 0.7,-1.812a0.993,0.993 0,0 1,0.137 -0.241,0.2 0.2,0 0,0 0.025,-0.033 1.292,1.292 0,0 1,1.025 -0.511,1.278 1.278,0 0,1 0.42,0.071 0.3,0.3 0,0 0,0.038 0.015l0.5,0.189 -0.175,0.45L12,14.932c-0.009,0.025 -0.014,0.057 -0.025,0.081l-1.707,4.441a2.821,2.821 0,0 1,-5.212 0.137,2.613 2.613,0 0,1 -0.213,-0.733A2.973,2.973 0,0 1,5.013 17.438Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M11.521,20.977l0.771,-0.446 0.085,-0.052L11.469,18.9l-0.061,-0.1a0.871,0.871 0,0 1,-0.109 -0.3,1.379 1.379,0 0,1 -0.009,-0.572 1.4,1.4 0,0 1,0.161 -0.407h0a1.307,1.307 0,0 1,0.454 -0.445l0.458,-0.265 0.577,1c0.015,0.025 0.033,0.048 0.048,0.071L15.367,22a2.509,2.509 0,0 1,0.151 0.308,2.823 2.823,0 0,1 -5.042,2.517 2.784,2.784 0,0 1,0.98 -3.814h0l0.065,-0.036Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M22.49,20.92a2.823,2.823 0,0 1,-2.365 4.347,2.461 2.461,0 0,1 -0.445,-0.038A2.827,2.827 0,0 1,17.339 22l0.076,-0.469 0.081,-0.506 -1.911,-0.3a0.887,0.887 0,0 1,-0.3 -0.1,1.272 1.272,0 0,1 -0.42,-0.322 1.3,1.3 0,0 1,-0.3 -1.05l0.081,-0.524 1.14,0.18a0.613,0.613 0,0 1,0.085 0.009l4.7,0.748a2.775,2.775 0,0 1,1.93 1.262Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M13.9,23.233a0.943,0.943 0,0 0,-0.113 -0.312l-0.5,-0.856 -0.856,0.5a0.989,0.989 0,0 0,-0.364 1.348l0.085,0.127a0.96,0.96 0,0 0,0.511 0.332,1.216 1.216,0 0,0 0.255,0.037 1,1 0,0 0,0.492 -0.132A0.977,0.977 0,0 0,13.9 23.233Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M8,17.534a1.006,1.006 0,0 0,-0.355 -0.066,0.991 0.991,0 0,0 -0.989,0.992 0.975,0.975 0,0 0,0.085 0.4s0,0 0,0.01a0.991,0.991 0,0 0,1.825 -0.057l0.175,-0.454 0.18,-0.464Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M24.842,15.486a0.993,0.993 0,0 0,-1.636 -0.393h0l0,0.005 -0.7,0.7 0.549,0.549 0.147,0.146a0.964,0.964 0,0 0,0.7 0.284,0.987 0.987,0 0,0 0.994,-0.979v0A0.769,0.769 0,0 0,24.842 15.486Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M9.124,10.916a0.991,0.991 0,0 0,-0.94 -0.685,0.994 0.994,0 0,0 -0.942,1.3c0.014,0.047 0.038,0.09 0.057,0.137a1,1 0,0 0,0.885 0.549,0.971 0.971,0 0,0 0.307,-0.048l0.89,-0.293 0.052,-0.014Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M15.117,7.01a0.993,0.993 0,0 0,-0.445 -0.752,1.008 1.008,0 0,0 -0.747,-0.138 0.991,0.991 0,0 0,-0.762 1.173,1.041 1.041,0 0,0 0.227,0.455 0.9,0.9 0,0 0,0.2 0.17l0.828,0.534 0.534,-0.827A0.874,0.874 0,0 0,15.117 7.01Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M21.058,22.154a0.98,0.98 0,0 0,-0.794 -0.69l-0.974,-0.151 -0.152,0.974a0.982,0.982 0,0 0,0.435 0.979,0.892 0.892,0 0,0 0.388,0.147 0.579,0.579 0,0 0,0.161 0.009,0.981 0.981,0 0,0 0.979,-0.985 0.964,0.964 0,0 0,-0.043 -0.282Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M22.08,9.01a1.269,1.269 0,0 0,-0.025 -0.137,0.989 0.989,0 0,0 -1.944,0.341l0.105,0.979 0.368,-0.043 0.616,-0.066a0.977,0.977 0,0 0,0.884 -1.061h0v0Z"
                    , Color.parseColor("#ffffff"))
    );
    //endregion lightLogoPathList

    //region darkLogoPathList
    public static final List<VectorDrawableCreator.PathData> darkLogoPathList = Arrays.asList(
            new VectorDrawableCreator.PathData("M52.509,17.586a5.87,5.87 0,0 0,-1.833 -1.225,5.732 5.732,0 0,0 -4.848,0.183 5.812,5.812 0,0 0,-1.734 1.372,5.838 5.838,0 0,0 -1.717,-1.372 5.526,5.526 0,0 0,-2.629 -0.628,5.65 5.65,0 0,0 -2.23,0.45A5.821,5.821 0,0 0,35.69 17.6a5.675,5.675 0,0 0,-1.225 1.811,5.587 5.587,0 0,0 -0.451,2.242v5.76h2.807V21.644a2.927,2.927 0,0 1,1.786 -2.7,2.993 2.993,0 0,1 2.288,0A2.9,2.9 0,0 1,42.471 20.5a2.823,2.823 0,0 1,0.225 1.136V27.4H45.5V21.644a2.911,2.911 0,0 1,0.225 -1.136,2.942 2.942,0 0,1 1.566,-1.566 2.757,2.757 0,0 1,1.136 -0.225,2.994 2.994,0 0,1 2.1,0.854 2.907,2.907 0,0 1,0.628 0.937,2.823 2.823,0 0,1 0.225,1.136V27.4H54.19v-5.76a5.676,5.676 0,0 0,-1.681 -4.058Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M66.89,19.4a6.023,6.023 0,0 0,-1.225 -1.822,5.924 5.924,0 0,0 -1.812,-1.225 5.739,5.739 0,0 0,-4.466 0,5.98 5.98,0 0,0 -1.838,1.225A5.852,5.852 0,0 0,56.308 19.4a5.757,5.757 0,0 0,1.241 6.31,6.07 6.07,0 0,0 1.838,1.241 5.725,5.725 0,0 0,2.23 0.45h5.729L67.346,21.65A5.685,5.685 0,0 0,66.89 19.4ZM64.545,24.605L61.617,24.605a3.066,3.066 0,0 1,-1.152 -0.225,3 3,0 0,1 -0.942,-0.623 2.786,2.786 0,0 1,-0.623 -0.948,2.855 2.855,0 0,1 -0.225,-1.147 2.911,2.911 0,0 1,0.225 -1.136,2.875 2.875,0 0,1 1.565,-1.566 2.933,2.933 0,0 1,3.221 0.629,2.755 2.755,0 0,1 0.628,0.937 2.823,2.823 0,0 1,0.225 1.136Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M80.05,19.4a5.528,5.528 0,0 0,-1.241 -1.812,5.991 5.991,0 0,0 -1.827,-1.225 5.746,5.746 0,0 0,-7.52 3.042,5.6 5.6,0 0,0 -0.45,2.241L69.012,33.981a2.807,2.807 0,0 0,2.807 -2.807h0L71.819,27.4h2.927a5.541,5.541 0,0 0,2.236 -0.45,5.826 5.826,0 0,0 3.068,-3.079 5.781,5.781 0,0 0,0 -4.477ZM77.516,22.825a3.034,3.034 0,0 1,-0.628 0.947,2.79 2.79,0 0,1 -0.943,0.623 2.914,2.914 0,0 1,-1.152 0.226L71.866,24.621L71.866,21.665a2.911,2.911 0,0 1,0.225 -1.136,2.942 2.942,0 0,1 1.566,-1.566 2.84,2.84 0,0 1,1.136 -0.225,3.082 3.082,0 0,1 1.152,0.225 2.915,2.915 0,0 1,1.8 2.7,3.147 3.147,0 0,1 -0.23,1.163Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M86.651,22.781a2.792,2.792 0,0 0,-0.869 -0.582,2.725 2.725,0 0,0 -2.1,0 2.584,2.584 0,0 0,-0.853 0.582,2.756 2.756,0 0,0 -0.582,0.858 2.715,2.715 0,0 0,-0.214 1.053V27.4h2.7a2.664,2.664 0,0 0,1.047 -0.214,2.707 2.707,0 0,0 0.869,-0.587 2.638,2.638 0,0 0,0.587 -0.869,2.725 2.725,0 0,0 0,-2.105A2.781,2.781 0,0 0,86.651 22.781Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M99.965,15.911a5.673,5.673 0,0 0,-2.231 0.45,5.907 5.907,0 0,0 -1.838,1.23A5.737,5.737 0,0 0,94.655 19.4a5.6,5.6 0,0 0,-0.45 2.241V27.4h2.833v-5.76a2.906,2.906 0,0 1,0.22 -1.136,2.937 2.937,0 0,1 1.565,-1.566 2.862,2.862 0,0 1,1.137 -0.225h0.209a2.806,2.806 0,0 0,2.807 -2.806h0S100.718,15.913 99.965,15.911Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M89.463,15.911h3.075v11.494h-3.075z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M91,11.214a1.655,1.655 0,1 0,1.655 1.655h0a1.654,1.654 0,0 0,-1.65 -1.655Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M30.209,15.349a14.661,14.661 0,0 1,-5.07 11.106L15.5,36.1 5.623,26.224a14.8,14.8 0,0 1,-2.847 -3.539A14.641,14.641 0,0 1,0.818 15.349v-0.033a14.378,14.378 0,0 1,0.558 -3.987v-0.005a0.269,0.269 0,0 1,0.019 -0.061,14.735 14.735,0 0,1 9.531,-9.881h0.009c0.043,-0.014 0.085,-0.025 0.128,-0.043l0.057,-0.019c0.024,-0.009 0.052,-0.014 0.08,-0.025l0.109,-0.033a0.085,0.085 0,0 1,0.038 -0.009A14.484,14.484 0,0 1,15.32 0.658H15.8A14.684,14.684 0,0 1,30.209 15.349Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M27.193,13.726a3.041,3.041 0,0 0,-0.321 -0.279,3.941 3.941,0 0,0 -2.422,-0.823 3.849,3.849 0,0 0,-0.416 0.019l-0.525,-0.611A3.789,3.789 0,0 0,24.246 7c-0.071,-0.066 -0.151,-0.132 -0.231,-0.194a3.962,3.962 0,0 0,-2.441 -0.837A3.9,3.9 0,0 0,18.3 7.691a3.509,3.509 0,0 0,-0.137 -0.961h0a3.729,3.729 0,0 0,-0.573 -1.187,3.913 3.913,0 0,0 -1.054,-0.994 4,4 0,0 0,-2.923 -0.525,3.837 3.837,0 0,0 -2.45,1.637A3.671,3.671 0,0 0,10.62 8.5c0.033,0.132 0.066,0.26 0.109,0.387 -0.052,-0.042 -0.109,-0.08 -0.166,-0.118a3.981,3.981 0,0 0,-3.457 -0.52,3.81 3.81,0 0,0 -2.261,1.878 3.715,3.715 0,0 0,-0.42 1.49A3.751,3.751 0,0 0,5.984 14.3a3.967,3.967 0,0 0,0.857 0.458l0.075,0.6a4,4 0,0 0,-1.338 0.558,3.767 3.767,0 0,0 -1.7,2.838 3.79,3.79 0,0 0,5.676 2.976l0.156,0.572a3.653,3.653 0,0 0,0.109 3.566,3.846 3.846,0 0,0 2.36,1.76 4.012,4.012 0,0 0,2.952 -0.379,3.758 3.758,0 0,0 1.892,-2.653c0,-0.01 0,-0.025 0,-0.038 0.019,0.047 0.048,0.09 0.067,0.132a3.855,3.855 0,0 0,2.861 2.034,4.536 4.536,0 0,0 0.615,0.048 3.973,3.973 0,0 0,2.28 -0.719,3.748 3.748,0 0,0 1.556,-2.46 3.848,3.848 0,0 0,-1.2 -3.467,3.426 3.426,0 0,0 -0.487,-0.369c0.1,0.047 0.2,0.09 0.3,0.132a4.034,4.034 0,0 0,1.437 0.265,3.935 3.935,0 0,0 2.747,-1.1 3.68,3.68 0,0 0,1.14 -2.663A3.758,3.758 0,0 0,27.193 13.726Z"
                    , Color.parseColor("#9b2347")),
            new VectorDrawableCreator.PathData("M26.87,13.446a2.7,2.7 0,0 0,-0.293 -0.321,3.767 3.767,0 0,0 -1.977,-1.04 3.854,3.854 0,0 0,-0.7 -0.061,3.613 3.613,0 0,0 -0.4,0.019 3.785,3.785 0,1 0,-4.8 -5.852,3.849 3.849,0 0,0 -0.54,0.543h0c-0.085,0.1 -0.165,0.218 -0.241,0.332a3.912,3.912 0,0 0,-0.326 -1.519,3.781 3.781,0 0,0 -7.151,2.328c0.033,0.132 0.062,0.265 0.1,0.392a1.9,1.9 0,0 0,-0.161 -0.118A3.785,3.785 0,0 0,5.978 14.3a3.939,3.939 0,0 0,0.856 0.458,3.932 3.932,0 0,0 -0.68,0.218 4.025,4.025 0,0 0,-0.625 0.341,3.783 3.783,0 0,0 4.02,6.4 3.918,3.918 0,0 0,-0.284 0.785,3.833 3.833,0 0,0 0.085,2.128 3.5,3.5 0,0 0,0.308 0.677A3.78,3.78 0,0 0,16.668 24a4.257,4.257 0,0 0,0.336 0.6c0.025,0.037 0.048,0.066 0.072,0.1a3.755,3.755 0,0 0,2.445 1.481,4.393 4.393,0 0,0 0.6,0.047 3.778,3.778 0,0 0,3.731 -3.188,3.941 3.941,0 0,0 -0.662,-2.9c-0.057,-0.081 -0.119,-0.161 -0.18,-0.237a3.489,3.489 0,0 0,-0.8 -0.71,3.791 3.791,0 0,0 4.663,-5.746Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M23.9,12.978A2.8,2.8 0,0 1,25.9 13.8a3.293,3.293 0,0 1,0.3 0.355,2.822 2.822,0 0,1 -4.29,3.638l-0.7,-0.7L19.836,18.47a0.989,0.989 0,0 1,-0.26 0.184,1.3 1.3,0 0,1 -1.433,-0.124c-0.038,-0.033 -0.071,-0.061 -0.109,-0.1l-0.378,-0.378 0.819,-0.818q0.03,-0.032 0.057,-0.066l1.244,-1.244 1.277,-1.277 0.837,-0.837a2.862,2.862 0,0 1,2.015 -0.833Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M20.8,6.309c0.1,-0.009 0.2,-0.014 0.3,-0.014a2.821,2.821 0,0 1,0.288 5.628l-0.979,0.1 0.2,1.925a1.023,1.023 0,0 1,-0.019 0.317,1.291 1.291,0 0,1 -1.135,1.056l-0.194,0.019 -0.335,0.038 -0.124,-1.15c0,-0.033 -0.01,-0.057 -0.015,-0.085l-0.5,-4.74a2.812,2.812 0,0 1,2.493 -3.1h0s0.009,0 0.009,0Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M17.822,10.722a1.3,1.3 0,0 1,0.109 1.547l-0.293,0.445 -0.966,-0.629a0.412,0.412 0,0 1,-0.075 -0.047L12.605,9.445a2.82,2.82 0,0 1,-0.829 -3.9h0a2.821,2.821 0,0 1,5.189 1.532,2.859 2.859,0 0,1 -0.455,1.537l-0.534,0.828 0.515,0.336L17.6,10.5a2.892,2.892 0,0 1,0.217 0.227Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M5.667,9.942a2.819,2.819 0,0 1,5.192 0.411l0.308,0.94 1.839,-0.6a0.984,0.984 0,0 1,0.28 -0.047h0.071a1.286,1.286 0,0 1,1.229 0.894l0.067,0.213 0.1,0.3 -1.1,0.362a0.475,0.475 0,0 0,-0.081 0.033l-4.522,1.47A2.822,2.822 0,0 1,5.5 12.108c-0.038,-0.128 -0.071,-0.255 -0.1,-0.383a2.891,2.891 0,0 1,0.265 -1.783Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M5.013,17.438A2.822,2.822 0,0 1,8.66 15.82l0.922,0.356 0.7,-1.812a0.993,0.993 0,0 1,0.137 -0.241,0.285 0.285,0 0,0 0.025,-0.033 1.292,1.292 0,0 1,1.025 -0.511,1.278 1.278,0 0,1 0.42,0.071 0.3,0.3 0,0 0,0.038 0.015l0.5,0.189 -0.175,0.45L12,14.932c-0.009,0.025 -0.014,0.057 -0.025,0.081l-1.707,4.441a2.821,2.821 0,0 1,-5.212 0.137,2.613 2.613,0 0,1 -0.213,-0.733A2.973,2.973 0,0 1,5.013 17.438Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M11.521,20.977l0.771,-0.446 0.085,-0.052L11.469,18.9l-0.061,-0.1a0.871,0.871 0,0 1,-0.109 -0.3,1.379 1.379,0 0,1 -0.009,-0.572 1.4,1.4 0,0 1,0.161 -0.407h0a1.307,1.307 0,0 1,0.454 -0.445l0.458,-0.265 0.577,1c0.015,0.025 0.033,0.048 0.048,0.071L15.367,22a2.509,2.509 0,0 1,0.151 0.308,2.823 2.823,0 0,1 -5.042,2.517 2.784,2.784 0,0 1,0.98 -3.814h0l0.065,-0.036Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M22.49,20.92a2.823,2.823 0,0 1,-2.365 4.347,2.461 2.461,0 0,1 -0.445,-0.038A2.827,2.827 0,0 1,17.339 22l0.076,-0.469 0.081,-0.506 -1.911,-0.3a0.887,0.887 0,0 1,-0.3 -0.1,1.272 1.272,0 0,1 -0.42,-0.322 1.3,1.3 0,0 1,-0.3 -1.05l0.081,-0.524 1.14,0.18a0.613,0.613 0,0 1,0.085 0.009l4.7,0.748a2.775,2.775 0,0 1,1.93 1.262Z"
                    , Color.parseColor("#e71566")),
            new VectorDrawableCreator.PathData("M13.9,23.233a0.943,0.943 0,0 0,-0.113 -0.312l-0.5,-0.856 -0.856,0.5a0.989,0.989 0,0 0,-0.364 1.348l0.085,0.127a0.96,0.96 0,0 0,0.511 0.332,1.216 1.216,0 0,0 0.255,0.037 1,1 0,0 0,0.492 -0.132A0.977,0.977 0,0 0,13.9 23.233Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M8,17.534a1.006,1.006 0,0 0,-0.355 -0.066,0.991 0.991,0 0,0 -0.989,0.992 0.975,0.975 0,0 0,0.085 0.4s0,0 0,0.01a0.991,0.991 0,0 0,1.825 -0.057l0.175,-0.454 0.18,-0.464Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M24.842,15.486a0.993,0.993 0,0 0,-1.636 -0.393h0l0,0.005 -0.7,0.7 0.549,0.549 0.146,0.146a0.968,0.968 0,0 0,0.7 0.284,0.987 0.987,0 0,0 0.994,-0.979v0A0.769,0.769 0,0 0,24.842 15.486Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M9.124,10.916a0.991,0.991 0,0 0,-0.94 -0.685,0.994 0.994,0 0,0 -0.942,1.3c0.014,0.047 0.038,0.09 0.057,0.137a0.991,0.991 0,0 0,1.192 0.5l0.89,-0.293 0.052,-0.014Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M15.117,7.01a0.993,0.993 0,0 0,-0.445 -0.752,1.008 1.008,0 0,0 -0.747,-0.138 0.991,0.991 0,0 0,-0.762 1.173,1.041 1.041,0 0,0 0.227,0.455 0.9,0.9 0,0 0,0.2 0.17l0.828,0.534 0.534,-0.827A0.874,0.874 0,0 0,15.117 7.01Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M21.058,22.154a0.98,0.98 0,0 0,-0.794 -0.69l-0.974,-0.151 -0.152,0.974a0.982,0.982 0,0 0,0.435 0.979,0.892 0.892,0 0,0 0.388,0.147 0.579,0.579 0,0 0,0.161 0.009,0.981 0.981,0 0,0 0.979,-0.985 0.964,0.964 0,0 0,-0.043 -0.282Z"
                    , Color.parseColor("#ffffff")),
            new VectorDrawableCreator.PathData("M22.08,9.01a1.269,1.269 0,0 0,-0.025 -0.137,0.989 0.989,0 0,0 -1.944,0.341l0.105,0.979 0.368,-0.043 0.616,-0.066a0.977,0.977 0,0 0,0.884 -1.061h0v0Z"
                    , Color.parseColor("#ffffff"))
    );
    //endregion darkLogoPathList

    //region compassIconPathList
    public static final List<VectorDrawableCreator.PathData> compassIconPathList = Arrays.asList(
            new VectorDrawableCreator.PathData("M20,20m-19.8,0a19.8,19.8 0,1 1,39.6 0a19.8,19.8 0,1 1,-39.6 0"
                    , Color.parseColor("#000000")),
            new VectorDrawableCreator.PathData("M17.4,17.2c1.5,1.4 3.8,1.4 5.3,0c1.4,-1.5 1.4,-3.8 0,-5.2L20,9.2l-2.6,2.6C15.9,13.3 15.9,15.7 17.4,17.2L17.4,17.2L17.4,17.2z"
                    , Color.parseColor("#ed1c5a")),
            new VectorDrawableCreator.PathData("M19.6,6.7h0.8V2.8h-0.8V6.7zM13.1,4.3l1.5,3.6l0.7,-0.3L13.8,4L13.1,4.3zM24.7,7.6l0.7,0.3l1.5,-3.6L26.2,4L24.7,7.6zM29.1,10.4l0.6,0.6l2.8,-2.8l-0.6,-0.6L29.1,10.4zM7.6,8.1l2.8,2.8l0.6,-0.6L8.1,7.6L7.6,8.1zM4,13.8l3.6,1.5l0.3,-0.7l-3.6,-1.5L4,13.8zM32.1,14.5l0.3,0.7l3.6,-1.5l-0.3,-0.7L32.1,14.5zM33.3,20.4h3.9v-0.8h-3.9V20.4zM2.8,20.4h3.9v-0.8H2.8V20.4zM32.1,25.4l3.6,1.5l0.3,-0.7l-3.6,-1.5L32.1,25.4zM4,26.2l0.3,0.7l3.6,-1.5l-0.3,-0.7L4,26.2zM29.1,29.6l2.8,2.8l0.6,-0.6l-2.8,-2.8L29.1,29.6zM7.6,31.9l0.5,0.6l2.8,-2.8l-0.6,-0.5L7.6,31.9zM24.7,32.4l1.5,3.6l0.7,-0.3l-1.5,-3.6L24.7,32.4zM13.1,35.7l0.7,0.3l1.5,-3.6l-0.7,-0.3L13.1,35.7zM19.6,37.2h0.8v-3.9h-0.8V37.2z"
                    , Color.parseColor("#ffffff"))
    );
    //endregion compassIconPathList
}