package ir.map.sdk_map.maps

import android.content.Context
import androidx.core.content.ContextCompat
import com.mapbox.mapboxsdk.camera.CameraPosition
import com.mapbox.mapboxsdk.geometry.LatLng
import com.mapbox.mapboxsdk.maps.MapView
import com.mapbox.mapboxsdk.maps.MapboxMap
import com.mapbox.mapboxsdk.module.http.HttpRequestUtil
import ir.map.mapsdk.R
import ir.map.sdk_map.utils.NetworkUtils

class MapInit {
    var map: MapboxMap? = null

    fun init(
        mapView: MapView, style: String, context: Context, apiKey: String
    ) {
        HttpRequestUtil.setOkHttpClient(NetworkUtils(context).getOkHttpClient(apiKey))

        mapView.getMapAsync { mapboxMap ->
            map = mapboxMap
            map!!.uiSettings.setCompassImage(
                ContextCompat.getDrawable(
                    context,
                    R.drawable.ic_compass
                )!!
            )
            map!!.uiSettings.setLogoMargins(10000, 0, 0, 0)
            map!!.uiSettings.setAttributionMargins(10000, 0, 0, 0)
            mapboxMap.setStyle(style)
            mapboxMap.cameraPosition =
                CameraPosition.Builder().target(LatLng(35.690975, 51.433868)).zoom(6.0).build()
        }

    }
}