package ir.map.servicesdk.request;

import java.util.ArrayList;
import java.util.List;

import ir.map.servicesdk.enums.StaticMapMarker;
import ir.map.servicesdk.model.base.BaseModel;
import ir.map.servicesdk.model.inner.CustomMarker;

public class StaticMapRequest extends BaseModel {

    private double latitude;
    private double longitude;
    private int width;
    private int height;
    private int zoom;
    private String label;
    private StaticMapMarker color;

    private List<CustomMarker> markers;

    public StaticMapRequest(double latitude, double longitude, int width, int height, int zoom, String label, StaticMapMarker color) {
        this.markers = new ArrayList<>();
        this.latitude = latitude;
        this.longitude = longitude;
        this.width = width;
        this.height = height;
        this.label = label;
        this.color = color;

        if (zoom < 1 || zoom > 20)
            throw new RuntimeException("Zomm level for static map api must be between 1 and 20; (can't be " + zoom);
        else
            this.zoom = zoom;
    }

    public StaticMapRequest(List<CustomMarker> markers, int width, int height, int zoom) {
        this.markers = markers;
        this.width = width;
        this.height = height;

        if (zoom < 1 || zoom > 20)
            throw new RuntimeException("Zomm level for static map api must be between 1 and 20; (can't be " + zoom);
        else
            this.zoom = zoom;
    }

    public double getLatitude() {
        return latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public int getZoom() {
        return zoom;
    }

    public String getLabel() {
        return label;
    }

    public StaticMapMarker getColor() {
        return color;
    }

    public List<CustomMarker> getMarkers() {
        return markers;
    }

    public static class Builder {

        private int width;
        private int height;
        private int zoom;

        private List<CustomMarker> markers;

        public Builder(int width, int height, int zoom) {
            this.width = width;
            this.height = height;
            this.zoom = zoom;

            this.markers = new ArrayList<>();
        }

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.zoom = 12;

            this.markers = new ArrayList<>();
        }

        public StaticMapRequest.Builder addMarker(Double latitude, Double longitude, String label, StaticMapMarker markerType) {
            this.markers.add(new CustomMarker(latitude, longitude, label, markerType));

            return this;
        }

        public StaticMapRequest build() {
            if (markers.isEmpty())
                throw new RuntimeException("Markers list can not be empty, add at least one CustomMarker to makers list.");

            return new StaticMapRequest(markers, width, height, zoom);
        }
    }
}
