package ir.msob.jima.auditlog.commons.model;

import ir.msob.jima.core.commons.model.relateddomain.RelatedDomainFilters;
import ir.msob.jima.core.commons.model.relatedparty.RelatedPartyFilters;
import ir.msob.jima.core.commons.model.timeperiod.TimePeriodFilters;
import lombok.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@Setter
@Getter
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class AuditLogCriteria<ID extends Comparable<ID> & Serializable> {
    private RelatedDomainFilters<ID> relatedDomain;
    private RelatedPartyFilters relatedParty;
    private TimePeriodFilters date;
    private Collection<AuditLogOperation> operations = new ArrayList<>(Arrays.asList(AuditLogOperation.values()));
}
