package ir.msob.jima.auditlog.commons.model;

import ir.msob.jima.core.commons.model.domain.BaseDomain;
import ir.msob.jima.core.commons.model.dto.ModelType;
import ir.msob.jima.core.commons.model.relateddomain.RelatedDomain;
import ir.msob.jima.core.commons.model.relatedparty.RelatedParty;
import lombok.*;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;

@Setter
@Getter
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class AuditLogAbstract<ID extends Comparable<ID> & Serializable>
        extends ModelType
        implements BaseDomain<ID> {
    private ID id;
    private RelatedParty relatedParty;
    private AuditLogOperation operation;
    private RelatedDomain<ID> relatedDomain;
    private Instant date = Instant.now();
    private Collection<AuditLogDetail> details;

    @Override
    public String getDomainIdName() {
        return FN.id.name();
    }

    @Override
    public ID getDomainId() {
        return getId();
    }

    @Override
    public void setDomainId(ID id) {
        setId(id);
    }

    public enum FN {
        id, relatedParty, operation, relatedDomain, date, details
    }

}
