package ir.msob.jima.auditlog.service;

import ir.msob.jima.auditlog.commons.model.AuditLogAbstract;
import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.model.channel.ChannelMessage;
import ir.msob.jima.core.commons.security.BaseUser;
import ir.msob.jima.core.commons.util.GenericTypeUtil;

import java.io.Serializable;
import java.util.Optional;

public interface BaseAuditLogReceiver<ID extends Comparable<ID> & Serializable, USER extends BaseUser, AL extends AuditLogAbstract<ID>> {

    default Class<AL> getAuditLogClass() {
        return (Class<AL>) GenericTypeUtil.resolveTypeArguments(getClass(), BaseAuditLogReceiver.class, 2);
    }

    @MethodStats
    void receive(ChannelMessage< USER, AL> channelMessage, Optional<USER> user);
}
