package ir.msob.jima.auditlog.service;

import ir.msob.jima.auditlog.commons.model.AuditLogAbstract;
import ir.msob.jima.auditlog.commons.model.AuditLogCriteria;
import ir.msob.jima.core.commons.annotation.methodstats.MethodStats;
import ir.msob.jima.core.commons.security.BaseUser;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.io.Serializable;
import java.util.Optional;

public interface BaseAuditLogService<ID extends Comparable<ID> & Serializable, USER extends BaseUser, AL extends AuditLogAbstract<ID>> {
    @MethodStats
    Flux<AL> getMany(AuditLogCriteria<ID> criteria, Optional<USER> user);

    @MethodStats
    Mono<Page<AL>> getPage(AuditLogCriteria<ID> criteria, Pageable pageable, Optional<USER> user);

    @MethodStats
    Mono<AL> save(AL auditLog, Optional<USER> user);
}
