/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cache.ral.redisson.beans;

import ir.msob.jima.cache.commons.BaseMapCacheService;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class MapCacheService
implements BaseMapCacheService {
    private final RedissonClient redissonClient;

    public <T> Optional<T> get(String group, String key) {
        RMapCache mapCache = this.redissonClient.getMapCache(group);
        Object value = mapCache.get((Object)key);
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public <T> T put(String group, String key, T value) {
        RMapCache mapCache = this.redissonClient.getMapCache(group);
        return (T)mapCache.put((Object)key, value);
    }

    public <T> T put(String group, String key, T value, long ttl, TimeUnit ttlUnit) {
        RMapCache mapCache = this.redissonClient.getMapCache(group);
        return (T)mapCache.put((Object)key, value, ttl, ttlUnit);
    }

    public <T> T put(String group, String key, T value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        RMapCache mapCache = this.redissonClient.getMapCache(group);
        return (T)mapCache.put((Object)key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit);
    }

    public <T> Optional<T> getAndRemove(String group, String key) {
        RMapCache mapCache = this.redissonClient.getMapCache(group);
        Object value = mapCache.remove((Object)key);
        return value == null ? Optional.empty() : Optional.of(value);
    }

    public boolean remove(String group) {
        return this.redissonClient.getMapCache(group).delete();
    }

    public MapCacheService(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

