/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.beans;

import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import ir.msob.jima.cloud.rsocket.commons.model.ConnectionInfo;
import ir.msob.jima.core.commons.logger.Logger;
import ir.msob.jima.core.commons.logger.LoggerFactory;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.rsocket.server.RSocketServer;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.stereotype.Service;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

@Service
public class RequesterBuilder {
    private final RSocketRequester.Builder rsocketRequesterBuilder;
    private final RSocketStrategies rsocketStrategies;
    private final RetryBackoffSpec retryBackoffSpec = Retry.backoff((long)1000L, (Duration)Duration.ofMillis(500L));
    Logger log = LoggerFactory.getLog(RequesterBuilder.class);

    public Builder builder() {
        return new Builder();
    }

    @Generated
    public RequesterBuilder(RSocketRequester.Builder rsocketRequesterBuilder, RSocketStrategies rsocketStrategies) {
        this.rsocketRequesterBuilder = rsocketRequesterBuilder;
        this.rsocketStrategies = rsocketStrategies;
    }

    public class Builder {
        private final List<Object> candidateHandlers = new ArrayList<Object>();
        private ConnectionInfo connectionInfo;
        private String setupRoute;
        private Object setupData;

        public Builder connectionInfo(ConnectionInfo connectionInfo) {
            this.connectionInfo = connectionInfo;
            return this;
        }

        public Builder setupRoute(String setupRoute) {
            this.setupRoute = setupRoute;
            return this;
        }

        public Builder setupData(Object setupData) {
            this.setupData = setupData;
            return this;
        }

        public Builder addHandler(Object candidateHandlers) {
            this.candidateHandlers.add(candidateHandlers);
            return this;
        }

        public Builder addHandlers(List<Object> candidateHandlers) {
            if (candidateHandlers != null && !candidateHandlers.isEmpty()) {
                this.candidateHandlers.addAll(candidateHandlers);
            }
            return this;
        }

        public RSocketRequester build() {
            RSocketRequester.Builder builder = RequesterBuilder.this.rsocketRequesterBuilder.rsocketStrategies(RequesterBuilder.this.rsocketStrategies).rsocketConnector(connector -> connector.acceptor(this.getSocketAcceptor(this.candidateHandlers)).reconnect((Retry)RequesterBuilder.this.retryBackoffSpec));
            RSocketRequester requester = this.initTransport(this.connectionInfo, builder);
            requester.rsocketClient().source().flatMap(RSocket::onClose).repeat().log().retryWhen((Retry)RequesterBuilder.this.retryBackoffSpec).doOnError(error -> RequesterBuilder.this.log.warn("Connection closed. builder {}", error, new Object[]{this})).doFinally(consumer -> RequesterBuilder.this.log.info("Connection disconnected. consumer {} builder {}", new Object[]{consumer, this})).subscribe();
            return requester;
        }

        private SocketAcceptor getSocketAcceptor(List<Object> candidateHandlers) {
            RSocketMessageHandler handler = new RSocketMessageHandler();
            handler.setHandlers(candidateHandlers);
            handler.setRSocketStrategies(RequesterBuilder.this.rsocketStrategies);
            handler.afterPropertiesSet();
            return handler.responder();
        }

        private RSocketRequester initTransport(ConnectionInfo connectionInfo, RSocketRequester.Builder builder) {
            if (connectionInfo.getTransport() == RSocketServer.Transport.TCP) {
                return builder.tcp(connectionInfo.getHost(), connectionInfo.getPort().intValue());
            }
            if (connectionInfo.getTransport() == RSocketServer.Transport.WEBSOCKET) {
                return builder.websocket(URI.create(connectionInfo.getServerUrl()));
            }
            throw new RuntimeException("Can not support transport: " + String.valueOf(connectionInfo.getTransport()));
        }

        @Generated
        public Builder() {
        }

        @Generated
        public String toString() {
            return "RequesterBuilder.Builder(candidateHandlers=" + String.valueOf(this.candidateHandlers) + ", connectionInfo=" + String.valueOf(this.connectionInfo) + ", setupRoute=" + this.setupRoute + ", setupData=" + String.valueOf(this.setupData) + ")";
        }
    }
}

