/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.beans;

import ir.msob.jima.cloud.rsocket.commons.model.InstanceInfo;
import ir.msob.jima.cloud.rsocket.commons.util.RoundRobinList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ApplicationCacheService {
    @Generated
    private static final Logger log = LogManager.getLogger(ApplicationCacheService.class);
    private final Map<String, RoundRobinList<InstanceInfo>> applications = new HashMap<String, RoundRobinList<InstanceInfo>>();
    private final Object lockObject = new Object();

    public RoundRobinList<InstanceInfo> getInstanceInfos(String applicationName) {
        return this.applications.getOrDefault(applicationName, (RoundRobinList<InstanceInfo>)new RoundRobinList());
    }

    public InstanceInfo getInstanceInfo(String applicationName) {
        return (InstanceInfo)this.getInstanceInfos(applicationName).next();
    }

    public InstanceInfo getInstanceInfoExcept(String applicationName, InstanceInfo instanceInfo) {
        return (InstanceInfo)this.getInstanceInfos(applicationName).nextExcept((Object)instanceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<InstanceInfo> inputs) {
        log.info("Register application. instanceInfos {}", inputs);
        Object object = this.lockObject;
        synchronized (object) {
            for (InstanceInfo instanceInfo : inputs) {
                RoundRobinList instanceInfos = this.applications.get(instanceInfo.getApplicationName());
                if (instanceInfos == null) {
                    instanceInfos = new RoundRobinList();
                }
                if (instanceInfos.stream().anyMatch(ii -> Objects.equals(ii.getInstanceId(), instanceInfo.getInstanceId()))) {
                    return;
                }
                instanceInfos.add((Object)instanceInfo);
                this.applications.put(instanceInfo.getApplicationName(), (RoundRobinList<InstanceInfo>)instanceInfos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection<InstanceInfo> inputs) {
        log.info("Unregister application. instanceInfos {}", inputs);
        Object object = this.lockObject;
        synchronized (object) {
            for (InstanceInfo instanceInfo : inputs) {
                RoundRobinList<InstanceInfo> instanceInfos = this.applications.get(instanceInfo.getApplicationName());
                if (instanceInfos == null) {
                    return;
                }
                instanceInfos.removeIf(ii -> Objects.equals(ii.getInstanceId(), instanceInfo.getInstanceId()));
                if (instanceInfos.isEmpty()) {
                    this.applications.remove(instanceInfo.getApplicationName());
                    continue;
                }
                this.applications.put(instanceInfo.getApplicationName(), instanceInfos);
            }
        }
    }

    @Generated
    public ApplicationCacheService() {
    }

    @Generated
    public Map<String, RoundRobinList<InstanceInfo>> getApplications() {
        return this.applications;
    }
}

