package ir.msob.jima.cloud.rsocket.client;

import ir.msob.jima.cloud.rsocket.commons.model.ClientPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.stereotype.Controller;

import static ir.msob.jima.cloud.rsocket.commons.Constants.CLIENT_SETUP_ROUTE;

@Controller
@RequiredArgsConstructor
@Log4j2
public class ClientSetupController {
    private final BaseClientSetupService baseClientSetupService;

    @MessageMapping(CLIENT_SETUP_ROUTE)
    public void setup(RSocketRequester requester, @Payload ClientPayload payload) {
        log.info("Received {} request: {}", CLIENT_SETUP_ROUTE, payload);
        baseClientSetupService.setup(requester, payload);
    }

}
