/*
 * Decompiled with CFR 0.152.
 */
package ir.msob.jima.cloud.rsocket.client;

import ir.msob.jima.cloud.rsocket.commons.model.ClientPayload;
import ir.msob.jima.cloud.rsocket.commons.model.RequestPayload;
import ir.msob.jima.core.commons.logger.Logger;
import ir.msob.jima.core.commons.logger.LoggerFactory;
import lombok.Generated;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ClientRequester {
    private final RSocketRequester.Builder rsocketRequesterBuilder;
    private final Logger log = LoggerFactory.getLog(ClientRequester.class);

    public RSocketRequester.Builder buildRequester(String clientId) {
        this.log.debug("Building requester for clientId: {}", new Object[]{clientId});
        return this.rsocketRequesterBuilder.setupRoute("gateway-server.client.connect", new Object[0]).setupData((Object)this.prepareSetupPayload(clientId));
    }

    public <R> Mono<R> requestResponse(RSocketRequester requester, String clientId, String applicationName, String route, Object data, Class<R> responseClass) {
        this.log.debug("Sending request-response with clientId: {}, applicationName: {}, route: {}", new Object[]{clientId, applicationName, route});
        return requester.route("gateway-server.client.request-response", new Object[0]).data((Object)this.buildRequestPayload(clientId, applicationName, route, data)).retrieveMono(responseClass).doOnSuccess(response -> this.log.debug("Request-response succeeded with response: {}", new Object[]{response})).doOnError(error -> this.log.error("Request-response failed with error: {}", new Object[]{error.getMessage()}));
    }

    public Mono<Void> fireAndForget(RSocketRequester requester, String clientId, String applicationName, String route, Object data) {
        this.log.debug("Sending fire-and-forget with clientId: {}, applicationName: {}, route: {}", new Object[]{clientId, applicationName, route});
        return requester.route("gateway-server.client.fire-and-forget", new Object[0]).data((Object)this.buildRequestPayload(clientId, applicationName, route, data)).send().doOnSuccess(signal -> this.log.debug("Fire-and-forget completed successfully", new Object[0])).doOnError(error -> this.log.error("Fire-and-forget failed with error: {}", new Object[]{error.getMessage()}));
    }

    private RequestPayload buildRequestPayload(String clientId, String applicationName, String route, Object data) {
        return RequestPayload.builder().clientId(clientId).applicationName(applicationName).route(route).data(data).build();
    }

    private ClientPayload prepareSetupPayload(String clientId) {
        return ClientPayload.builder().clientId(clientId).build();
    }

    @Generated
    public ClientRequester(RSocketRequester.Builder rsocketRequesterBuilder) {
        this.rsocketRequesterBuilder = rsocketRequesterBuilder;
    }
}

