package ir.msob.jima.cloud.rsocket.commons.model;

import ir.msob.jima.core.commons.model.dto.ModelType;
import lombok.*;
import org.apache.logging.log4j.util.Strings;
import org.springframework.boot.rsocket.server.RSocketServer;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
@ToString
public class ConnectionInfo extends ModelType {
    private String uri;
    private String host = "localhost";
    private Integer port = 7002;
    private RSocketServer.Transport transport = RSocketServer.Transport.TCP;

    public String getServerUrl() {
        if (Strings.isBlank(getUri())) {
            if (Strings.isNotBlank(getHost()) && getTransport() != null && getPort() != null) {
                return String.format("%s://%s:%d", getTransportAsString(), getHost(), getPort());
            } else {
                throw new RuntimeException("Invalid rsocket server info : " + String.format("%s://%s:%d", getTransportAsString(), getHost(), getPort()));
            }
        } else {
            return getUri();
        }
    }

    public String getHost() {
        if (Strings.isBlank(this.host))
            return "localhost";
        return host;
    }

    public Integer getPort() {
        if (this.port == null)
            return 7002;
        return port;
    }

    public RSocketServer.Transport getTransport() {
        if (this.transport == null)
            return RSocketServer.Transport.TCP;
        return transport;
    }

    public String getTransportAsString() {
        if (transport == RSocketServer.Transport.TCP) {
            return "tcp";
        } else if (transport == RSocketServer.Transport.WEBSOCKET) {
            return "ws";
        } else {
            return "tcp";
        }
    }
}
