package ir.msob.jima.cloud.rsocket.commons.model;

import ir.msob.jima.core.commons.model.dto.ModelType;
import lombok.*;
import org.springframework.messaging.rsocket.RSocketRequester;

import java.util.Objects;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
@ToString
public class InstanceInfo extends ModelType {
    private String applicationName;
    private String instanceId;
    private ConnectionInfo connectionInfo;
    private RSocketRequester requester;

    @Override
    public InstanceInfo copy() {
        return InstanceInfo.builder()
                .applicationName(this.applicationName)
                .instanceId(this.instanceId)
                .connectionInfo(this.connectionInfo)
                .build();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof InstanceInfo)) {
            return false;
        }
        return Objects.equals(((InstanceInfo) o).getInstanceId(), this.getInstanceId());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
